/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.model.Attribute;
import io.intino.datahub.model.Component;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Reel;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.ReelFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;

public final class ReelMounter
extends MasterDatamartMounter {
    public ReelMounter(MasterDatamart datamart) {
        super(datamart);
    }

    @Override
    public void mount(Event event) {
        if (event instanceof MessageEvent) {
            MessageEvent e = (MessageEvent)event;
            this.mount(e.toMessage());
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        MessageEvent event = new MessageEvent(message);
        String ss = this.withoutParameters(event.ss());
        ReelFile reelFile = this.datamart.reelStore().get(ss);
        try {
            if (reelFile == null) {
                reelFile = this.reelFile(message.type(), ss);
            }
            this.update(reelFile, event);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void update(ReelFile reelFile, MessageEvent event) throws IOException {
        Datamart datamart = this.datamart.definition();
        List<Reel> reels = datamart.reelList(r -> r.signal(s -> s.tank().message().name$().equals(event.type())) != null);
        for (Reel reel : reels) {
            Reel.Signal signal = reel.signal(s -> s.tank().message().name$().equals(event.type()));
            String[] values = this.mappingAttribute(event.toMessage(), signal.attribute());
            if (signal.operation().equals((Object)Reel.Signal.Operation.Set)) {
                reelFile.set(event.ts(), values);
                continue;
            }
            if (values.length != 1) continue;
            reelFile.append(new Reel.Shot[]{new Reel.Shot(event.ts(), signal.attribute().name$(), values[0].equals(Reel.State.On.name()) ? Reel.State.On : Reel.State.Off)});
        }
    }

    private String[] mappingAttribute(Message message, Attribute from) {
        if (from.core$().owner().is(Component.class)) {
            return (String[])message.components().stream().flatMap(m -> ReelMounter.values(message, from)).toArray(String[]::new);
        }
        return (String[])ReelMounter.values(message, from).toArray(String[]::new);
    }

    private static Stream<String> values(Message message, Attribute from) {
        Message.Value value = message.get(from.name$());
        if (!value.isNull()) {
            return value.asList(String.class).stream();
        }
        return Stream.empty();
    }

    private ReelFile reelFile(String type, String ss) throws IOException {
        File file = new File(this.box().datamartReelsDirectory(this.datamart.name()), type + File.separator + ss + ".reel");
        file.getParentFile().mkdirs();
        return ReelFile.open((File)file);
    }

    private String withoutParameters(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }
}

