/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;

public final class EntityMounter
extends MasterDatamartMounter {
    public EntityMounter(MasterDatamart datamart) {
        super(datamart);
    }

    @Override
    public void mount(Event event) {
        if (event instanceof MessageEvent) {
            MessageEvent e = (MessageEvent)event;
            this.mount(e.toMessage());
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        try {
            String id = message.get("id").asString();
            if (this.isInvalidId(id) || EntityMounter.isDisabled(message)) {
                return;
            }
            Message oldMessage = this.datamart.entityStore().get(id);
            if (oldMessage != null) {
                this.update(message, id, oldMessage);
            } else {
                this.addNewEntity(message, id);
            }
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to mount message of type " + message.type() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void addNewEntity(Message message, String id) {
        this.datamart.entityStore().put(id, message);
    }

    private void update(Message message, String id, Message oldMessage) {
        if (!oldMessage.type().equals(message.type())) {
            throw new MismatchMessageTypeException("Id " + id + " already exists with a different message type: old=" + oldMessage.type() + ", new=" + message.type());
        }
        this.update(oldMessage, message);
    }

    private void update(Message message, Message changes) {
        for (String attribute : changes.attributes()) {
            message.set(attribute, changes.get(attribute).data());
        }
        this.removeAllComponents(message);
        message.add(changes.components());
    }

    private void removeAllComponents(Message message) {
        message.components().forEach(arg_0 -> ((Message)message).remove(arg_0));
    }

    private boolean isInvalidId(String id) {
        return id == null || id.isEmpty();
    }

    private static boolean isDisabled(Message message) {
        return message.contains("enabled") && message.get("enabled").asBoolean() == false;
    }

    private static class MismatchMessageTypeException
    extends IllegalStateException {
        public MismatchMessageTypeException(String message) {
            super(message);
        }
    }
}

