/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.message.Message;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.rules.DayOfWeek;
import io.intino.datahub.model.rules.SnapshotScale;
import io.intino.sumus.chronos.ReelFile;
import io.intino.sumus.chronos.TimelineFile;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public interface MasterDatamart {
    public Datamart definition();

    public DataHubBox box();

    public String name();

    public Store<Message> entityStore();

    public Store<TimelineFile> timelineStore();

    public Store<ReelFile> reelStore();

    public Stream<MasterDatamartMounter> createMountersFor(Datalake.Tank var1);

    public record Snapshot(Timetag timetag, MasterDatamart datamart) {
        public static boolean shouldCreateSnapshot(Timetag timetag, SnapshotScale scale, DayOfWeek firstDayOfWeek) {
            return switch (scale) {
                default -> throw new IncompatibleClassChangeError();
                case SnapshotScale.None -> false;
                case SnapshotScale.Day -> true;
                case SnapshotScale.Year -> Snapshot.isFirstDayOfYear(timetag);
                case SnapshotScale.Month -> Snapshot.isFirstDayOfMonth(timetag);
                case SnapshotScale.Week -> Snapshot.isFirstDayOfWeek(timetag, firstDayOfWeek);
            };
        }

        private static boolean isFirstDayOfYear(Timetag today) {
            return today.month() == 1 && today.day() == 1;
        }

        private static boolean isFirstDayOfMonth(Timetag today) {
            return today.day() == 1;
        }

        private static boolean isFirstDayOfWeek(Timetag today, DayOfWeek firstDayOfWeek) {
            return today.datetime().getDayOfWeek().name().equalsIgnoreCase(firstDayOfWeek.name());
        }
    }

    public static interface Store<T> {
        public int size();

        public boolean contains(String var1);

        public T get(String var1);

        public void put(String var1, T var2);

        public void remove(String var1);

        public Stream<T> stream();

        public Map<String, T> toMap();

        public Collection<String> subscribedEvents();

        public boolean isSubscribedTo(Datalake.Tank var1);
    }
}

