/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventStream;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.impl.LocalMasterDatamart;
import io.intino.datahub.datamart.mounters.EntityMounter;
import io.intino.datahub.datamart.mounters.ReelMounter;
import io.intino.datahub.datamart.mounters.TimelineMounter;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Reel;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.rules.DayOfWeek;
import io.intino.datahub.model.rules.SnapshotScale;
import java.io.IOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DatamartFactory {
    private final DataHubBox box;
    private final Datalake datalake;

    public DatamartFactory(DataHubBox box, Datalake datalake) {
        this.box = box;
        this.datalake = datalake;
    }

    public MasterDatamart create(Datamart definition) throws IOException {
        Reference<MasterDatamart> datamart = new Reference<MasterDatamart>();
        Reference<Timetag> fromTimetag = new Reference<Timetag>();
        if (this.failedToLoadLastSnapshotOf(definition, datamart, fromTimetag)) {
            datamart.value = new LocalMasterDatamart(this.box, definition);
            fromTimetag.value = null;
        }
        return this.reflow((MasterDatamart)datamart.value, (Timetag)fromTimetag.value, definition);
    }

    private boolean failedToLoadLastSnapshotOf(Datamart definition, Reference<MasterDatamart> datamart, Reference<Timetag> fromTimetag) {
        Optional<MasterDatamart.Snapshot> snapshot = this.box.datamartSerializer().loadMostRecentSnapshot(definition.name$());
        if (snapshot.isPresent()) {
            datamart.value = snapshot.get().datamart();
            fromTimetag.value = snapshot.get().timetag();
            return false;
        }
        return true;
    }

    private MasterDatamart reflow(MasterDatamart datamart, Timetag fromTimetag, Datamart definition) throws IOException {
        SnapshotScale scale = definition.snapshots() == null ? SnapshotScale.None : Optional.ofNullable(definition.snapshots().scale()).orElse(SnapshotScale.None);
        DayOfWeek firstDayOfWeek = definition.snapshots() == null ? DayOfWeek.MONDAY : definition.snapshots().firstDayOfWeek();
        Set<String> entityTanks = DatamartFactory.entityTanks(definition);
        Set<String> timelineTanks = DatamartFactory.timelineTanks(definition);
        Set<String> reelTanks = DatamartFactory.reelTanks(definition);
        EntityMounter entityMounter = new EntityMounter(datamart);
        TimelineMounter timelineMounter = new TimelineMounter(datamart);
        ReelMounter reelMounter = new ReelMounter(datamart);
        Iterator<Event> iterator = this.reflowTanksFrom(fromTimetag, entityTanks, timelineTanks, reelTanks);
        while (iterator.hasNext()) {
            Event event = iterator.next();
            this.createSnapshotIfNecessary(datamart, scale, firstDayOfWeek, event);
            if (entityTanks.contains(event.type())) {
                entityMounter.mount(event);
            }
            if (timelineTanks.contains(event.type())) {
                timelineMounter.mount(event);
            }
            if (!reelTanks.contains(event.type())) continue;
            reelMounter.mount(event);
        }
        return datamart;
    }

    private void createSnapshotIfNecessary(MasterDatamart datamart, SnapshotScale scale, DayOfWeek firstDayOfWeek, Event event) throws IOException {
        if (scale == SnapshotScale.None) {
            return;
        }
        Timetag timetag = Timetag.of((Instant)event.ts(), (Scale)Scale.Day);
        if (MasterDatamart.Snapshot.shouldCreateSnapshot(timetag, scale, firstDayOfWeek)) {
            this.box.datamartSerializer().saveSnapshot(timetag, datamart);
        }
    }

    private Iterator<Event> reflowTanksFrom(Timetag fromTimetag, Set<String> entityTanks, Set<String> timelineTanks, Set<String> reelTanks) {
        HashSet<String> tankNames = new HashSet<String>(entityTanks);
        tankNames.addAll(timelineTanks);
        tankNames.addAll(reelTanks);
        return EventStream.merge(this.tanks(tankNames).map(tank -> fromTimetag == null ? tank.content() : DatamartFactory.tankContentFrom(fromTimetag, (Datalake.Store.Tank<? extends Event>)tank))).iterator();
    }

    private static Stream<? extends Event> tankContentFrom(Timetag fromTimetag, Datalake.Store.Tank<? extends Event> tank) {
        return tank.content((ss, ts) -> !ts.isBefore(fromTimetag));
    }

    private Stream<Datalake.Store.Tank<? extends Event>> tanks(Set<String> tankNames) {
        return Stream.of(this.datalake.messageStore().tanks().filter(t -> tankNames.contains(t.name())), this.datalake.measurementStore().tanks().filter(t -> tankNames.contains(t.name())), this.datalake.resourceStore().tanks().filter(t -> tankNames.contains(t.name()))).flatMap(Function.identity());
    }

    private static Set<String> reelTanks(Datamart definition) {
        return definition.reelList().stream().flatMap(r -> Stream.concat(r.signalList().stream().map(DatamartFactory::tankName), Stream.of(DatamartFactory.tankName(r.entity())))).collect(Collectors.toSet());
    }

    private static Set<String> timelineTanks(Datamart definition) {
        return definition.timelineList().stream().flatMap(t -> Stream.of(DatamartFactory.tankName(t.tank().sensor()), DatamartFactory.tankName(t.entity()))).collect(Collectors.toSet());
    }

    private static Set<String> entityTanks(Datamart definition) {
        return definition.entityList().stream().filter(e -> e.from() != null).map(DatamartFactory::tankName).collect(Collectors.toSet());
    }

    private static String tankName(Reel.Signal s) {
        return s.core$().fullName().replace("$", ".");
    }

    private static String tankName(Sensor sensor) {
        return sensor.core$().fullName().replace("$", ".");
    }

    private static String tankName(Entity e) {
        return e.from().message().core$().fullName().replace("$", ".");
    }

    private static class Reference<T> {
        public T value;

        private Reference() {
        }
    }
}

