/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.regenerator;

import io.intino.datahub.datalake.regenerator.Mapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class MapperLoader {
    private final File home;

    public MapperLoader(File home) {
        this.home = new File(home, "mappers");
    }

    public Mapper compileAndLoad(String mapperCode) throws CompilationException, IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if ((mapperCode = mapperCode.trim()).startsWith("package")) {
            mapperCode = mapperCode.substring(mapperCode.indexOf("\n"));
        }
        this.home.mkdirs();
        String className = this.nameOf(mapperCode);
        File file = this.javaFile(className);
        Files.writeString(file.toPath(), (CharSequence)mapperCode, new OpenOption[0]);
        this.compile(file);
        return this.load(this.home, className);
    }

    public void delete(String mapperCode) {
        String name = this.nameOf(mapperCode);
        this.javaFile(name).delete();
        this.classFile(name).forEach(File::delete);
    }

    private void compile(File mapperJava) throws CompilationException, IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Collections.singletonList(mapperJava));
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
        task.call();
        fileManager.close();
        if (!diagnostics.getDiagnostics().isEmpty()) {
            throw new CompilationException(diagnostics.getDiagnostics().stream().map(d -> "Error on line " + d.getLineNumber() + ": " + d.getMessage(Locale.getDefault())).collect(Collectors.joining("\n")));
        }
    }

    private Mapper load(File home, String className) throws MalformedURLException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{home.toURI().toURL()}, classLoader);
        Class<?> javaDemoClass = urlClassLoader.loadClass(className);
        return (Mapper)javaDemoClass.getConstructors()[0].newInstance(new Object[0]);
    }

    private String nameOf(String mapperCode) {
        String class_ = "class ";
        int index = mapperCode.indexOf(class_);
        return mapperCode.substring(index + class_.length(), mapperCode.indexOf(" ", index + class_.length()));
    }

    private File javaFile(String className) {
        return new File(this.home, className + ".java");
    }

    private List<File> classFile(String className) {
        ArrayList<File> files = new ArrayList<File>();
        File e = new File(this.home, className + ".class");
        if (e.exists()) {
            files.add(e);
        }
        files.addAll(Arrays.stream(this.home.listFiles()).filter(f -> f.getName().startsWith(className + "$") && f.getName().endsWith(".class")).collect(Collectors.toList()));
        return files;
    }

    public static class CompilationException
    extends Exception {
        public CompilationException() {
        }

        public CompilationException(String message) {
            super(message);
        }

        public CompilationException(String message, Throwable cause) {
            super(message, cause);
        }

        public CompilationException(Throwable cause) {
            super(cause);
        }

        public CompilationException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

