/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.regenerator;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.FileTub;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageWriter;
import io.intino.alexandria.zim.Zim;
import io.intino.datahub.datalake.pump.EventPump;
import io.intino.datahub.datalake.pump.FileEventPump;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.RegeneratorReporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Comparator;

public class DatalakeRegenerator {
    protected final FileDatalake datalake;
    private final File reviewsDirectory;
    private final String ts;

    public DatalakeRegenerator(FileDatalake datalake, File reviewsDirectory, String ts) {
        this.datalake = datalake;
        this.reviewsDirectory = reviewsDirectory;
        this.ts = ts;
    }

    public File review(Mapper mapper) {
        File reportFile = new File(this.reviewsDirectory, this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        EventPump.Reflow reflow = new FileEventPump((Datalake.Store<? extends Event>)this.datalake.messageStore()).reflow(mapper.filter());
        while (reflow.hasNext()) {
            reflow.next(1, event -> this.review(mapper, reporter, (MessageEvent)event));
        }
        reporter.commit();
        return reportFile;
    }

    public File revise(Mapper mapper) {
        File reportFile = new File(this.datalake.root(), this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        this.datalake.messageStore().tanks().sorted(Comparator.comparing(Datalake.Store.Tank::name)).filter(tank -> mapper.filter().allow((Datalake.Store.Tank<? extends Event>)tank)).flatMap(Datalake.Store.Tank::sources).flatMap(Datalake.Store.Source::tubs).forEach(tub -> {
            MessageWriter writer = new MessageWriter(this.zim(this.temp((Datalake.Store.Tub<MessageEvent>)tub)));
            tub.events().forEach(e -> {
                String before = e.toMessage().toString();
                MessageEvent after = e;
                if (mapper.filter().allow((Event)e)) {
                    after = (MessageEvent)mapper.apply((Event)e);
                    reporter.addItem(before, after == null ? null : after.toString());
                }
                if (after != null) {
                    this.write(writer, after);
                }
            });
            this.close(writer);
            this.backupSourceTub(mapper, (Datalake.Store.Tub<MessageEvent>)tub);
            if (this.temp((Datalake.Store.Tub<MessageEvent>)tub).length() > 20L) {
                this.move(this.temp((Datalake.Store.Tub<MessageEvent>)tub), ((FileTub)tub).file());
            } else {
                this.temp((Datalake.Store.Tub<MessageEvent>)tub).delete();
            }
        });
        reporter.commit();
        return reportFile;
    }

    private void close(MessageWriter writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void write(MessageWriter writer, MessageEvent after) {
        try {
            writer.write(after.toMessage());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void review(Mapper mapper, RegeneratorReporter reporter, MessageEvent event) {
        if (mapper.filter().allow((Event)event)) {
            String before = event.toMessage().toString();
            Event after = mapper.apply((Event)event);
            reporter.addItem(before, after == null ? null : after.toString());
        }
    }

    private File temp(Datalake.Store.Tub<MessageEvent> tub) {
        return new File(((FileTub)tub).file().getAbsolutePath() + ".tmp");
    }

    private void backupSourceTub(Mapper mapper, Datalake.Store.Tub<MessageEvent> tub) {
        File source = ((FileTub)tub).file();
        File dest = new File(source.getParentFile(), this.mapperPrefixName(mapper) + "_" + source.getName() + ".bak");
        this.move(source, dest);
    }

    private String mapperPrefixName(Mapper mapper) {
        return "datalake_" + mapper.getClass().getSimpleName() + "_" + this.ts;
    }

    private void move(File source, File dest) {
        try {
            Files.move(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private OutputStream zim(File file) {
        try {
            return Zim.compressing((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

