/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.broker.jms;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.util.Collections;
import java.util.Iterator;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class JmsMessageTranslator {
    public static Iterator<Message> toInlMessages(javax.jms.Message message) {
        try {
            return JmsMessageTranslator.readMessages(((TextMessage)message).getText());
        }
        catch (Throwable e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    private static Iterator<Message> readMessages(String text) {
        return new MessageReader(text).iterator();
    }

    public static javax.jms.Message toJmsMessage(String message) {
        ActiveMQTextMessage activeMQTextMessage = new ActiveMQTextMessage();
        try {
            activeMQTextMessage.setText(message);
            return activeMQTextMessage;
        }
        catch (MessageNotWriteableException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

