/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.service.jms;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.jms.MessageReader;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.Message;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class DatamartsRequest {
    private final DataHubBox box;

    public DatamartsRequest(DataHubBox box) {
        this.box = box;
    }

    public Stream<Message> accept(Message request) {
        try {
            String content = MessageReader.textFrom((Message)request);
            return this.handleDatamartDownload(content);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> handleDatamartDownload(String request) {
        Map<String, String> args = this.parseArgumentsFrom(request);
        String datamartName = args.get("datamart");
        MasterDatamart datamart = this.box.datamarts().get(datamartName);
        if (datamart == null) {
            Logger.error((String)("Datamart " + datamartName + " not found"));
            return Stream.empty();
        }
        return switch (args.get("operation")) {
            case "snapshots" -> this.listAvailableSnapshotsOf(datamart);
            case "entities" -> this.downloadEntities(datamart, args);
            case "list-timelines" -> this.listTimelineFiles(datamart, args);
            case "get-timeline" -> this.getTimeline(datamart, args);
            case "list-reels" -> this.listReelFiles(datamart, args);
            case "get-reel" -> this.getReel(datamart, args);
            default -> Stream.empty();
        };
    }

    private Stream<Message> getReel(MasterDatamart datamart, Map<String, String> args) {
        return this.getChronos(args, this.box.datamartReelsDirectory(datamart.name()), ".reel");
    }

    private Stream<Message> getTimeline(MasterDatamart datamart, Map<String, String> args) {
        return this.getChronos(args, this.box.datamartTimelinesDirectory(datamart.name()), ".timeline");
    }

    private Stream<Message> getChronos(Map<String, String> args, File dir, String extension) {
        String id = args.get("id");
        if (id == null) {
            Logger.error((String)"Chronos object download requested but id argument not found");
            return Stream.empty();
        }
        String type = args.get("type");
        if (type == null) {
            Logger.error((String)"Chronos object download requested but type argument not found");
            return Stream.empty();
        }
        File file = new File(dir, type + File.pathSeparator + id + extension);
        if (!file.exists()) {
            return Stream.empty();
        }
        String mode = args.getOrDefault("mode", "download");
        return mode.equals("path") ? this.path(file) : this.download(file);
    }

    private Stream<Message> download(File file) {
        try {
            ActiveMQBytesMessage message = new ActiveMQBytesMessage();
            byte[] bytes = Files.readAllBytes(file.toPath());
            message.setProperty("name", (Object)file.getName());
            message.setIntProperty("size", bytes.length);
            message.writeBytes(bytes);
            message.compress();
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((String)("Could not send file " + file.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> path(File file) {
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setText(file.getAbsolutePath());
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((String)("Could not send file path " + file.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> listReelFiles(MasterDatamart datamart, Map<String, String> args) {
        return this.listFiles(datamart.name(), this.box.datamartReelFiles(datamart.name(), args.get("id")));
    }

    private Stream<Message> listTimelineFiles(MasterDatamart datamart, Map<String, String> args) {
        return this.listFiles(datamart.name(), this.box.datamartTimelineFiles(datamart.name(), args.get("id")));
    }

    private Stream<Message> listFiles(String datamart, List<File> files) {
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setText(files.stream().map(File::getAbsolutePath).collect(Collectors.joining(",")));
            message.setIntProperty("count", files.size());
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((String)("Could not list chronos files of " + datamart + ": " + e.getMessage()), (Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> downloadEntities(MasterDatamart datamart, Map<String, String> args) {
        Optional<String> timetag = Optional.ofNullable(args.get("timetag"));
        return timetag.map(s -> this.box.datamartSerializer().loadMostRecentSnapshotTo(datamart.name(), this.asTimetag((String)s)).map(MasterDatamart.Snapshot::datamart).map(this::downloadEntities).orElse(Stream.empty())).orElseGet(() -> datamart == null ? Stream.empty() : this.downloadEntities(datamart));
    }

    private Timetag asTimetag(String timetag) {
        return timetag.isEmpty() ? Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day) : Timetag.of((String)timetag);
    }

    private Stream<Message> listAvailableSnapshotsOf(MasterDatamart datamart) {
        List<Timetag> snapshots = this.box.datamartSerializer().listAvailableSnapshotsOf(datamart.name());
        if (snapshots.isEmpty()) {
            return Stream.empty();
        }
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setIntProperty("count", snapshots.size());
            message.setText(snapshots.stream().map(Timetag::value).collect(Collectors.joining(",")));
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> downloadEntities(MasterDatamart datamart) {
        try {
            ActiveMQBytesMessage message = new ActiveMQBytesMessage();
            message.setIntProperty("count", datamart.entityStore().size());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
            this.box.datamartSerializer().serialize(datamart, outputStream);
            byte[] bytes = outputStream.toByteArray();
            message.writeBytes(bytes);
            message.setIntProperty("size", bytes.length);
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private Map<String, String> parseArgumentsFrom(String request) {
        String[] command = request.split(";", -1);
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(command.length - 1);
        for (String argument : command) {
            String[] entry = argument.split("=", 2);
            if (entry.length < 2) continue;
            args.put(entry[0].trim(), entry[1].trim());
        }
        return args;
    }
}

