/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.serialization;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.serialization.MasterDatamartSerializer;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.NessGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MasterDatamartSnapshots {
    public static final String SNAPSHOT_EXTENSION = ".datamart.snapshot";

    public static void saveSnapshot(File datamartsRoot, Timetag timetag, MasterDatamart<?> datamart) throws IOException {
        File file = MasterDatamartSnapshots.snapshotDirOf(datamartsRoot, datamart.name() + "/" + timetag.value() + SNAPSHOT_EXTENSION);
        file.getParentFile().mkdirs();
        MasterDatamartSerializer.serialize(datamart, new FileOutputStream(file));
    }

    public static List<Timetag> listAvailableSnapshotsOf(File datamartsRoot, String datamartName) {
        return MasterDatamartSnapshots.listSnapshotFilesIn(MasterDatamartSnapshots.snapshotDirOf(datamartsRoot, datamartName)).stream().map(MasterDatamartSnapshots::timetagOf).collect(Collectors.toList());
    }

    public static <T> Optional<MasterDatamart.Snapshot<T>> loadMostRecentSnapshot(File datamartsRoot, String datamartName, NessGraph graph) {
        return MasterDatamartSnapshots.loadMostRecentSnapshotTo(datamartsRoot, datamartName, Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day), graph);
    }

    public static <T> Optional<MasterDatamart.Snapshot<T>> loadMostRecentSnapshotTo(File datamartsRoot, String datamartName, Timetag timetag, NessGraph graph) {
        return MasterDatamartSnapshots.findSnapshotFileOf(MasterDatamartSnapshots.snapshotDirOf(datamartsRoot, datamartName), timetag).map(f -> MasterDatamartSnapshots.deserialize(f, datamartName, graph));
    }

    private static <T> MasterDatamart.Snapshot<T> deserialize(File file, String datamartName, NessGraph graph) {
        try {
            MasterDatamart datamart = MasterDatamartSerializer.deserialize(new FileInputStream(file), MasterDatamartSnapshots.definitionOf(datamartName, graph));
            return new MasterDatamart.Snapshot(MasterDatamartSnapshots.timetagOf(file), datamart);
        }
        catch (IOException e) {
            Logger.error((String)("Failed to deserialize datamart snapshot " + file.getName() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static Datamart definitionOf(String name, NessGraph graph) {
        return graph.datamartList().stream().filter(d -> d.name$().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No datamart named " + name + " defined"));
    }

    private static Timetag timetagOf(File file) {
        try {
            String name = file.getName().replace(SNAPSHOT_EXTENSION, "");
            Timetag timetag = Timetag.of((String)name.substring(name.indexOf(46) + 1));
            timetag.datetime();
            return timetag;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static File snapshotDirOf(File datamartsRoot, String datamartName) {
        return new File(datamartsRoot, datamartName);
    }

    private static Optional<File> findSnapshotFileOf(File dir, Timetag timetag) {
        return MasterDatamartSnapshots.listSnapshotFilesIn(dir).stream().sorted(Collections.reverseOrder()).filter(f -> MasterDatamartSnapshots.snapshotIsEqualOrBefore(MasterDatamartSnapshots.timetagOf(f), timetag)).findFirst();
    }

    private static List<File> listSnapshotFilesIn(File dir) {
        File[] files = dir.listFiles(f -> f.getName().endsWith(SNAPSHOT_EXTENSION) && MasterDatamartSnapshots.timetagOf(f) != null);
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static boolean snapshotIsEqualOrBefore(Timetag snapshotTimetag, Timetag targetTimetag) {
        return snapshotTimetag.equals((Object)targetTimetag) || snapshotTimetag.isBefore(targetTimetag);
    }
}

