/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.messages;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.messages.MapMessageMasterDatamart;
import io.intino.datahub.datamart.messages.MasterDatamartMessageMounter;
import io.intino.datahub.datamart.serialization.MasterDatamartSerializer;
import io.intino.datahub.datamart.serialization.MasterDatamartSnapshots;
import io.intino.datahub.model.Datamart;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Optional;

public class MessageMasterDatamartFactory {
    private final DataHubBox box;
    private final File datamartsRoot;
    private final Datalake datalake;

    public MessageMasterDatamartFactory(DataHubBox box, File datamartsRoot, Datalake datalake) {
        this.box = box;
        this.datamartsRoot = datamartsRoot;
        this.datalake = datalake;
    }

    public MasterDatamart<Message> create(Datamart definition) throws IOException {
        Reference<MasterDatamart<Message>> datamart = new Reference<MasterDatamart<Message>>();
        Reference<Timetag> fromTimetag = new Reference<Timetag>();
        if (this.failedToLoadLastBackupOf(definition, datamart, fromTimetag)) {
            if (this.failedToLoadLastSnapshotOf(definition, datamart, fromTimetag)) {
                datamart.value = new MapMessageMasterDatamart(definition);
                fromTimetag.value = null;
            }
            this.reflow((MasterDatamart)datamart.value, (Timetag)fromTimetag.value, definition);
        }
        return (MasterDatamart)datamart.value;
    }

    private boolean failedToLoadLastBackupOf(Datamart definition, Reference<MasterDatamart<Message>> datamart, Reference<Timetag> fromTimetag) {
        File backup = MasterDatamartSerializer.backupFileOf(definition, this.box);
        if (!backup.exists()) {
            return true;
        }
        try {
            datamart.value = MasterDatamartSerializer.deserialize(backup, definition);
        }
        catch (IOException e) {
            Logger.error((String)("Could not deserialize datamart " + definition.name$() + " from " + backup + ": " + e.getMessage()), (Throwable)e);
            return true;
        }
        return false;
    }

    private boolean failedToLoadLastSnapshotOf(Datamart definition, Reference<MasterDatamart<Message>> datamart, Reference<Timetag> fromTimetag) {
        Optional snapshot = MasterDatamartSnapshots.loadMostRecentSnapshot(this.datamartsRoot, definition.name$(), this.box.graph());
        if (snapshot.isPresent()) {
            datamart.value = snapshot.get().datamart();
            fromTimetag.value = snapshot.get().timetag();
            return false;
        }
        return true;
    }

    private void reflow(MasterDatamart<Message> datamart, Timetag fromTimetag, Datamart definition) throws IOException {
        MasterDatamartMessageMounter mounter = new MasterDatamartMessageMounter(datamart);
        Iterator<MessageEvent> iterator = this.reflowEntityTanksFrom(fromTimetag, definition);
        int count = 0;
        while (iterator.hasNext()) {
            MessageEvent event = iterator.next();
            Timetag timetag = Timetag.of((Instant)event.ts(), (Scale)Scale.Day);
            if (MasterDatamart.Snapshot.shouldCreateSnapshot(timetag, definition.scale(), definition.firstDayOfWeek())) {
                MasterDatamartSnapshots.saveSnapshot(this.datamartsRoot, timetag, datamart);
            }
            mounter.mount(event.toMessage());
            ++count;
        }
        Logger.info((String)("Reflow finished for datamart " + datamart.name() + " (events = " + count + ")"));
    }

    private Iterator<MessageEvent> reflowEntityTanksFrom(Timetag fromTimetag, Datamart definition) {
        return definition.entityList().stream().filter(e -> e.from() != null).map(e -> this.datalake.messageStore().tank(e.from().message().core$().fullName().replace("$", "."))).flatMap(t -> fromTimetag == null ? t.content() : t.content((ss, ts) -> !ts.isBefore(fromTimetag))).iterator();
    }

    private static class Reference<T> {
        public T value;

        private Reference() {
        }
    }
}

