/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.messages;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;

public class MasterDatamartMessageMounter {
    private final MasterDatamart<Message> datamart;

    public MasterDatamartMessageMounter(MasterDatamart<Message> datamart) {
        this.datamart = datamart;
    }

    public void mount(Message message) {
        try {
            String id = message.get("id").asString();
            if (this.isInvalidId(id) || MasterDatamartMessageMounter.isDisabled(message)) {
                return;
            }
            Message oldMessage = this.datamart.get(id);
            if (oldMessage != null) {
                if (!oldMessage.type().equals(message.type())) {
                    throw new MismatchMessageTypeException("Id " + id + " already exists with a different message type: old=" + oldMessage.type() + ", new=" + message.type());
                }
                this.update(oldMessage, message);
            } else {
                this.datamart.put(id, message);
            }
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to mount message of type " + message.type() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void update(Message message, Message changes) {
        for (String attribute : changes.attributes()) {
            message.set(attribute, changes.get(attribute).data());
        }
        this.removeAllComponents(message);
        message.add(changes.components());
    }

    private void removeAllComponents(Message message) {
        message.components().forEach(arg_0 -> ((Message)message).remove(arg_0));
    }

    private boolean isInvalidId(String id) {
        return id == null || id.isEmpty();
    }

    private static boolean isDisabled(Message message) {
        return message.contains("enabled") && message.get("enabled").asBoolean() == false;
    }

    private static class MismatchMessageTypeException
    extends IllegalStateException {
        public MismatchMessageTypeException(String message) {
            super(message);
        }
    }
}

