/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Timeline;
import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimelineStore;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TimelineUtils {
    public static String sourceSensor(Event event) {
        Map<String, String> parameters = TimelineUtils.parameters(event.ss());
        String sensor = parameters.get("sensor");
        String cleanSS = TimelineUtils.withOutParameters(event.ss());
        return sensor == null ? cleanSS : sensor;
    }

    private static String withOutParameters(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }

    private static Map<String, String> parameters(String ss) {
        int i = ss.indexOf("?");
        if (i < 0 || i == ss.length() - 1) {
            return Map.of();
        }
        String[] parameters = ss.substring(i + 1).split(";");
        return Arrays.stream(parameters).map(p -> p.split("=")).collect(Collectors.toMap(p -> p[0], p -> p[1]));
    }

    static Magnitude[] sensorModel(TimelineStore.SensorModel current, Message assertion, Timeline timeline) {
        Sensor sensor = timeline.asRaw().tank().sensor();
        return (Magnitude[])sensor.magnitudeList().stream().map(m -> new Magnitude(m.id(), new Magnitude.Model(TimelineUtils.merge(m, current, assertion, m.attributeList(), timeline.asRaw().attributeList())))).toArray(Magnitude[]::new);
    }

    private static Map<String, String> merge(Sensor.Magnitude m, TimelineStore.SensorModel current, Message message, List<Sensor.Magnitude.Attribute> magnitudeAttr, List<Timeline.Raw.Attribute> timelineAttr) {
        Magnitude magnitude;
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Sensor.Magnitude.Attribute attribute : magnitudeAttr) {
            attrs.put(attribute.name$(), attribute.value());
        }
        if (current != null && (magnitude = current.get(m.id())) != null) {
            Magnitude.Model model = magnitude.model;
            model.attributes().forEach(a -> attrs.put((String)a, model.attribute(a)));
        }
        if (message == null) {
            return attrs;
        }
        TimelineUtils.addMessageAttributes(m, message, timelineAttr, attrs);
        return attrs;
    }

    private static void addMessageAttributes(Sensor.Magnitude m, Message message, List<Timeline.Raw.Attribute> timelineAttr, Map<String, String> attrs) {
        timelineAttr.stream().filter(a -> ((Object)((Object)a.magnitude())).equals((Object)m)).forEach(a -> {
            String value = TimelineUtils.valueOf(message, a.from());
            if (value != null) {
                attrs.put(a.name$(), value);
            }
        });
    }

    public static Stream<String> types(Timeline t) {
        return TimelineUtils.asTypes(TimelineUtils.tanksOf(t));
    }

    public static Stream<String> tanksOf(Timeline t) {
        HashSet<String> tanks = new HashSet<String>();
        String entityTank = TimelineUtils.tankName(t.entity());
        if (entityTank != null) {
            tanks.add(entityTank);
        }
        if (t.isRaw()) {
            tanks.add(TimelineUtils.tankName(t.asRaw().tank().sensor()));
        } else {
            tanks.addAll(TimelineUtils.getCookedTanks(t));
        }
        return tanks.stream();
    }

    public static Set<String> getCookedTanks(Timeline t) {
        HashSet<String> tanks = new HashSet<String>();
        t.asCooked().timeSeriesList().stream().map(ts -> TimelineUtils.tankName(ts.tank())).forEach(tanks::add);
        t.asCooked().timeSeriesList().stream().filter(Timeline.Cooked.TimeSeries::isCount).flatMap(ts -> TimelineUtils.tanksOf(ts.asCount())).forEach(tanks::add);
        return tanks;
    }

    private static Stream<String> asTypes(Stream<String> tanks) {
        return tanks.map(t -> t.contains(".") ? t.substring(t.lastIndexOf(".") + 1) : t);
    }

    public static Stream<String> tanksOf(Timeline.Cooked.TimeSeries.Count ts) {
        return ts.operationList().stream().map(d -> TimelineUtils.tankName(d.tank()));
    }

    private static String tankName(Sensor sensor) {
        return sensor.core$().fullName().replace("$", ".");
    }

    private static String tankName(Datalake.Tank.Message tank) {
        return tank.message().core$().fullName().replace("$", ".");
    }

    public static String tankName(Entity e) {
        return e.from() == null ? null : e.from().message().core$().fullName().replace("$", ".");
    }

    public static TimelineStore getOrCreateTimelineStoreOfRawTimeline(File datamartDir, MasterDatamart datamart, Instant start, String name, String entity) throws IOException {
        File file = TimelineUtils.timelineFileOf(datamartDir, name, entity);
        file.getParentFile().mkdirs();
        if (file.exists()) {
            return TimelineStore.of((File)file);
        }
        Timeline tlDefinition = datamart.definition().timelineList().stream().filter(Timeline::isRaw).filter(t -> t.asRaw().tank().sensor().name$().equals(name)).findFirst().orElseThrow(() -> new IOException("Tank not found: " + name));
        return TimelineStore.createIfNotExists((String)entity, (File)file).withSensorModel(TimelineUtils.sensorModel(null, datamart.entityStore().get(entity), tlDefinition)).withTimeModel(start, new Period(tlDefinition.asRaw().tank().period(), tlDefinition.asRaw().tank().periodScale().chronoUnit())).build();
    }

    public static File timelineFileOf(File datamartDir, String name, String entity) {
        return new File(datamartDir, name + File.separator + entity + ".timeline");
    }

    private static String valueOf(Message message, Entity.Attribute source) {
        return message.get(source.name$()).asString();
    }
}

