/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.TimelineUtils;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.function.Supplier;

public class TimelineRawMounter {
    private final DataHubBox box;
    private final MasterDatamart datamart;

    public TimelineRawMounter(DataHubBox box, MasterDatamart datamart) {
        this.box = box;
        this.datamart = datamart;
    }

    public void mount(MeasurementEvent event) {
        try {
            if (event.ss() == null) {
                return;
            }
            TimelineStore store = this.getOrCreate(event, TimelineUtils.sourceSensor((Event)event));
            this.update(store, event);
        }
        catch (Exception e) {
            Logger.error((String)("Could not mount event " + event.type() + ", ss = " + event.ss() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private TimelineStore getOrCreate(MeasurementEvent event, String sensor) throws IOException {
        TimelineStore store = this.datamart.timelineStore().get(event.type(), sensor);
        if (store == null) {
            store = TimelineUtils.getOrCreateTimelineStoreOfRawTimeline(this.box.datamartTimelinesDirectory(this.datamart.name()), this.datamart, event.ts(), event.type(), sensor);
        }
        return store;
    }

    protected void update(TimelineStore tlStore, MeasurementEvent event) {
        try (TimelineWriter writer = tlStore.writer();){
            TimelineRawMounter.checkTs(event.ts(), writer);
            writer.set(event.values());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static double[] measurementsOf(MeasurementEvent event, TimelineStore tlStore) {
        TimelineStore.SensorModel sensorModel = tlStore.sensorModel();
        double[] measurements = new double[sensorModel.size()];
        Arrays.fill(measurements, Double.NaN);
        for (int i = 0; i < event.magnitudes().length; ++i) {
            double value;
            int index = sensorModel.indexOf(TimelineRawMounter.name(event, i));
            measurements[index] = value = index >= 0 ? event.values()[i] : Double.NaN;
        }
        return measurements;
    }

    private static void checkTs(Instant ts, TimelineWriter writer) throws IOException {
        long lapse = Duration.between(writer.header().next(), ts).getSeconds();
        if (lapse > writer.timeModel().period().duration() * 2L) {
            writer.set(ts);
        }
    }

    private static String name(MeasurementEvent event, int i) {
        String name = event.magnitudes()[i].name();
        return name.contains("=") ? name.substring(0, name.indexOf(":")) : name;
    }

    public static class OfSingleTimeline
    extends TimelineRawMounter {
        private final Supplier<TimelineWriter> writer;

        public OfSingleTimeline(MasterDatamart datamart, Supplier<TimelineWriter> writer) {
            super(datamart.box(), datamart);
            this.writer = writer;
        }

        @Override
        public void mount(MeasurementEvent event) {
            try {
                TimelineWriter writer = this.writer.get();
                TimelineRawMounter.checkTs(event.ts(), writer);
                writer.set(event.values());
            }
            catch (Exception e) {
                Logger.error((String)("Could not mount event " + event.type() + ", ss = " + event.ss() + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

