/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.datamart.mounters.TimelineAssertionMounter;
import io.intino.datahub.datamart.mounters.TimelineCookedMounter;
import io.intino.datahub.datamart.mounters.TimelineRawMounter;
import io.intino.datahub.datamart.mounters.TimelineUtils;
import io.intino.datahub.model.Timeline;
import io.intino.magritte.framework.Layer;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TimelineMounter
extends MasterDatamartMounter {
    private final TimelineRawMounter rawMounter;
    private final TimelineAssertionMounter assertionMounter;
    private final TimelineCookedMounter cookedMounter;
    private final Map<String, Set<String>> timelineTypes;

    public TimelineMounter(MasterDatamart datamart) {
        super(datamart);
        this.timelineTypes = datamart.definition().timelineList().stream().collect(Collectors.toMap(Layer::name$, t -> TimelineUtils.types(t).collect(Collectors.toSet())));
        this.rawMounter = this.rawMounter(datamart);
        this.assertionMounter = new TimelineAssertionMounter(this.box(), datamart);
        this.cookedMounter = new TimelineCookedMounter(this.box(), datamart, this.timelineTypes);
    }

    protected TimelineRawMounter rawMounter(MasterDatamart datamart) {
        return new TimelineRawMounter(this.box(), datamart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mount(Event event) {
        MasterDatamart masterDatamart = this.datamart;
        synchronized (masterDatamart) {
            if (event instanceof MeasurementEvent) {
                MeasurementEvent e = (MeasurementEvent)event;
                this.rawMounter.mount(e);
            } else if (event instanceof MessageEvent) {
                MessageEvent e = (MessageEvent)event;
                this.mount(e.toMessage());
            }
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        if (this.isAssertion(message)) {
            this.assertionMounter.mount(new MessageEvent(message));
        } else if (this.isCooked(message)) {
            this.cookedMounter.mount(new MessageEvent(message));
        } else if (this.hasValues(message)) {
            this.rawMounter.mount(TimelineMounter.measurementEvent(message));
        }
    }

    private boolean hasValues(Message message) {
        return message.contains("values");
    }

    private boolean isAssertion(Message message) {
        return this.datamart.definition().timelineList().stream().filter(t -> t.entity().from() != null).anyMatch(t -> t.entity().from().message().name$().equals(message.type()));
    }

    private boolean isCooked(Message message) {
        return this.datamart.definition().timelineList().stream().filter(Timeline::isCooked).anyMatch(t -> this.timelineTypes.get(t.name$()).contains(message.type()));
    }

    private static MeasurementEvent measurementEvent(Message message) {
        return new MeasurementEvent(message.type(), message.get("ss").asString(), message.get("ts").asInstant(), TimelineMounter.measurements(message), TimelineMounter.values(message));
    }

    private static MeasurementEvent.Magnitude[] measurements(Message message) {
        List measurements = message.get("magnitudes").asList(String.class);
        return (MeasurementEvent.Magnitude[])measurements.stream().map(TimelineMounter::magnitude).toArray(MeasurementEvent.Magnitude[]::new);
    }

    private static MeasurementEvent.Magnitude magnitude(String m) {
        String[] fields = m.split(";");
        return new MeasurementEvent.Magnitude(fields[0], TimelineMounter.attributes(fields));
    }

    private static MeasurementEvent.Magnitude.Attribute[] attributes(String[] m) {
        return (MeasurementEvent.Magnitude.Attribute[])Arrays.stream(m).skip(1L).map(a -> new MeasurementEvent.Magnitude.Attribute(a.split("="))).toArray(MeasurementEvent.Magnitude.Attribute[]::new);
    }

    private static double[] values(Message message) {
        return Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray();
    }

    public static class OfSingleTimeline
    implements AutoCloseable {
        private final TimelineRawMounter.OfSingleTimeline rawMounter;
        private final TimelineAssertionMounter.OfSingleTimeline assertionMounter;
        private final String ss;
        private TimelineWriter writer;
        private final TimelineFileFactory timelineFactory;

        public OfSingleTimeline(MasterDatamart datamart, Timeline timeline, String tank, String ss) {
            this.ss = ss;
            this.timelineFactory = ts -> TimelineUtils.getOrCreateTimelineStoreOfRawTimeline(datamart.box().datamartTimelinesDirectory(datamart.name()), datamart, ts, tank, ss);
            this.rawMounter = new TimelineRawMounter.OfSingleTimeline(datamart, this::getTimelineWriter);
            this.assertionMounter = new TimelineAssertionMounter.OfSingleTimeline(datamart, timeline, this::getTimelineWriter);
        }

        public void mount(Event event) {
            this.createTimelineFileIfNotExists(event.ts());
            if (event instanceof MeasurementEvent) {
                MeasurementEvent e = (MeasurementEvent)event;
                this.rawMounter.mount(e);
            } else if (event instanceof MessageEvent) {
                MessageEvent e = (MessageEvent)event;
                if (this.ss.equals(TimelineUtils.sourceSensor(event))) {
                    this.assertionMounter.mount(new MessageEvent(e.toMessage()));
                }
            }
        }

        private void createTimelineFileIfNotExists(Instant ts) {
            if (this.writer != null) {
                return;
            }
            try {
                this.writer = this.timelineFactory.create(ts).writer();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.writer != null) {
                this.writer.close();
            }
        }

        private TimelineWriter getTimelineWriter() {
            return this.writer;
        }

        private static interface TimelineFileFactory {
            public TimelineStore create(Instant var1) throws Exception;
        }
    }
}

