/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.TimeShiftCache;
import io.intino.datahub.model.Timeline;
import io.intino.magritte.framework.Layer;
import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.MeasurementsVector;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimeSeries;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TimelineCookedMounter {
    private final MasterDatamart datamart;
    private final Map<String, Set<String>> timelineTypes;
    private final File directory;

    public TimelineCookedMounter(DataHubBox box, MasterDatamart datamart, Map<String, Set<String>> timelineTypes) {
        this.datamart = datamart;
        this.timelineTypes = timelineTypes;
        this.directory = box.datamartTimelinesDirectory(datamart.name());
    }

    public void mount(MessageEvent event) {
        this.datamart.definition().timelineList().stream().filter(Timeline::isCooked).map(Timeline::asCooked).filter(t -> this.timelineTypes.getOrDefault(t.name$(), Set.of()).contains(event.type())).forEach(t -> this.process(event, (Timeline.Cooked)((Object)t)));
    }

    private void process(MessageEvent event, Timeline.Cooked definition) {
        try {
            TimelineStore timelineFile = this.getOrCreateTimelineStore(event, definition);
            if (timelineFile == null) {
                return;
            }
            this.update(timelineFile, definition, event);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private TimelineStore getOrCreateTimelineStore(MessageEvent event, Timeline.Cooked timelineDef) throws IOException {
        String entityId = this.entityOf(event, timelineDef);
        if (entityId == null) {
            return null;
        }
        TimelineStore timelineFile = this.datamart.timelineStore().get(timelineDef.name$(), entityId);
        if (timelineFile == null) {
            timelineFile = this.createTimelineStore(timelineDef, event.ts(), entityId);
        }
        return timelineFile;
    }

    private String entityOf(MessageEvent event, Timeline.Cooked definition) {
        Timeline.Cooked.TimeSeries timeSeries = definition.timeSeries(ts -> ts.tank().message().name$().equals(event.type()));
        if (timeSeries != null) {
            return event.toMessage().get(timeSeries.entityId().name$()).asString();
        }
        for (Timeline.Cooked.TimeSeries series : definition.timeSeriesList()) {
            if (series.isCount()) {
                Timeline.Cooked.TimeSeries.Count.Operation operation = series.asCount().operation(o -> o.tank().message().name$().equals(event.type()));
                if (operation == null) continue;
                return event.toMessage().get(operation.entityId().name$()).asString();
            }
            if (!series.asTimeShift().withTank().message().name$().equals(event.type())) continue;
            return event.toMessage().get(series.asTimeShift().withEntityId().name$()).asString();
        }
        return null;
    }

    private void update(TimelineStore tlFile, Timeline.Cooked definition, MessageEvent event) {
        try (TimelineWriter writer = tlFile.writer();){
            writer.set(event.ts());
            for (Timeline.Cooked.TimeSeries ts : this.timeSeries(definition, event.type())) {
                writer.set(this.measurementsIn(tlFile, event, ts));
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private MeasurementsVector measurementsIn(TimelineStore tlFile, MessageEvent event, Timeline.Cooked.TimeSeries ts) throws IOException {
        MeasurementsVector measurements = new MeasurementsVector(tlFile.sensorModel());
        if (ts.isCount()) {
            this.processCount(measurements, ts.asCount(), TimelineCookedMounter.lastValue(tlFile, ts), this.operationOf(ts.asCount().operationList(), event.type()));
        } else {
            this.processTimeShift(measurements, ts.asTimeShift(), event);
        }
        return measurements;
    }

    private Timeline.Cooked.TimeSeries.Count.Operation operationOf(List<Timeline.Cooked.TimeSeries.Count.Operation> operations, String type) {
        return operations.stream().filter(o -> o.tank().message().name$().equals(type)).findFirst().orElse(null);
    }

    private void processCount(MeasurementsVector measurements, Timeline.Cooked.TimeSeries.Count ts, TimeSeries.Point last, Timeline.Cooked.TimeSeries.Count.Operation operation) {
        double value;
        double d = value = last == null ? 0.0 : last.value();
        if (operation instanceof Timeline.Cooked.TimeSeries.Count.Difference) {
            measurements.set(ts.name$(), value - 1.0);
        } else {
            measurements.set(ts.name$(), value + 1.0);
        }
    }

    private void processTimeShift(MeasurementsVector measurements, Timeline.Cooked.TimeSeries.TimeShift timeSeries, MessageEvent event) {
        if (event.type().equals(timeSeries.tank().message().name$())) {
            this.save(timeSeries, event);
        } else {
            Instant last = this.load(timeSeries, event);
            if (last != null) {
                measurements.set(timeSeries.name$(), (double)last.until(event.ts(), ChronoUnit.SECONDS));
            }
        }
    }

    private void save(Timeline.Cooked.TimeSeries.TimeShift timeSeries, MessageEvent event) {
        TimeShiftCache cache = this.cache(timeSeries);
        cache.put(event.toMessage().get(timeSeries.entityId().name$()).asString(), event.ts());
    }

    private Instant load(Timeline.Cooked.TimeSeries.TimeShift timeSeries, MessageEvent event) {
        return this.cache(timeSeries).get(event.toMessage().get(timeSeries.entityId().name$()).asString());
    }

    private TimeShiftCache cache(Timeline.Cooked.TimeSeries.TimeShift timeseries) {
        return this.datamart.cacheOf(((Timeline)timeseries.core$().ownerAs(Timeline.class)).name$());
    }

    private static TimeSeries.Point lastValue(TimelineStore tlFile, Timeline.Cooked.TimeSeries ts) throws IOException {
        TimeSeries.Point point;
        for (point = tlFile.timeline().get(ts.name$()).last(); point != null && Double.isNaN(point.value()); point = point.prev()) {
        }
        return point;
    }

    private List<Timeline.Cooked.TimeSeries> timeSeries(Timeline.Cooked definition, String type) {
        return definition.timeSeriesList(ts -> this.timelineTypes.get(definition.name$()).contains(type));
    }

    private TimelineStore createTimelineStore(Timeline.Cooked timeline, Instant start, String entity) throws IOException {
        File file = new File(this.directory, MasterDatamart.ChronosDirectory.normalizePath(timeline.name$() + File.separator + entity + ".timeline"));
        file.getParentFile().mkdirs();
        return TimelineStore.createIfNotExists((String)entity, (File)file).withTimeModel(start, new Period(1, ChronoUnit.HOURS)).withSensorModel(TimelineCookedMounter.sensorModel(timeline)).build();
    }

    static Magnitude[] sensorModel(Timeline.Cooked timeline) {
        return (Magnitude[])timeline.timeSeriesList().stream().map(ts -> new Magnitude(ts.name$(), new Magnitude.Model(ts.attributeList().stream().collect(Collectors.toMap(Layer::name$, Timeline.Cooked.TimeSeries.Attribute::value))))).toArray(Magnitude[]::new);
    }
}

