/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.TimelineUtils;
import io.intino.datahub.model.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;

public class TimelineAssertionMounter {
    private final DataHubBox box;
    private final MasterDatamart datamart;

    public TimelineAssertionMounter(DataHubBox box, MasterDatamart datamart) {
        this.box = box;
        this.datamart = datamart;
    }

    void mount(MessageEvent assertion) {
        this.datamart.definition().timelineList().stream().filter(t -> t.entity().from() != null && t.entity().from().message().name$().equals(assertion.type())).findFirst().ifPresent(t -> this.updateSensorModel(assertion, (Timeline)((Object)t)));
    }

    void updateSensorModel(MessageEvent assertion, Timeline t) {
        try {
            File timelineDirectory = new File(this.box.datamartTimelinesDirectory(this.datamart.name()), t.asRaw().tank().sensor().name$());
            File file = new File(timelineDirectory, assertion.toMessage().get("id").asString() + ".timeline");
            if (!file.exists()) {
                return;
            }
            try (TimelineWriter writer = TimelineStore.of((File)file).writer();){
                writer.sensorModel(TimelineUtils.sensorModel(TimelineStore.of((File)file).sensorModel(), assertion.toMessage(), t));
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static class OfSingleTimeline
    extends TimelineAssertionMounter {
        private final Timeline timeline;
        private final Supplier<TimelineWriter> writer;

        public OfSingleTimeline(MasterDatamart datamart, Timeline timeline, Supplier<TimelineWriter> writer) {
            super(datamart.box(), datamart);
            this.timeline = timeline;
            this.writer = writer;
        }

        @Override
        void mount(MessageEvent assertion) {
            try {
                this.writer.get().sensorModel(TimelineUtils.sensorModel(this.writer.get().sensorModel(), assertion.toMessage(), this.timeline));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }
}

