/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.model.Attribute;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Reel;
import io.intino.sumus.chronos.ReelFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ReelMounter
extends MasterDatamartMounter {
    public ReelMounter(MasterDatamart datamart) {
        super(datamart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mount(Event event) {
        MasterDatamart masterDatamart = this.datamart;
        synchronized (masterDatamart) {
            if (event instanceof MessageEvent) {
                MessageEvent e = (MessageEvent)event;
                this.mount(e.toMessage());
            }
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        MessageEvent event = new MessageEvent(message);
        String subject = this.subject(event);
        try {
            ReelFile reelFile = this.datamart.reelStore().get(message.type(), subject);
            if (reelFile == null) {
                reelFile = this.reelFile(message.type(), subject);
            }
            this.update(reelFile, event);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    String subject(MessageEvent event) {
        Datamart datamart = this.datamart.definition();
        Reel reel = datamart.reel(r -> r.tank().message().name$().equals(event.type()));
        return event.toMessage().get(reel.entitySource().name$()).asString();
    }

    protected void update(ReelFile reelFile, MessageEvent event) throws IOException {
        Datamart datamart = this.datamart.definition();
        List<Reel> reels = datamart.reelList(r -> r.tank().message().name$().equals(event.type()));
        for (Reel reel : reels) {
            reelFile.set(event.ts(), this.group(event, reel.groupSource()), this.mappingAttribute(event.toMessage(), reel));
        }
    }

    String group(MessageEvent event, Attribute attribute) {
        Message.Value value = event.toMessage().get(attribute.name$());
        return !value.isNull() ? value.asString() : event.type().toLowerCase();
    }

    String[] mappingAttribute(Message message, Reel reel) {
        return (String[])ReelMounter.values(message, reel.signals()).toArray(String[]::new);
    }

    private static Stream<String> values(Message message, Attribute from) {
        Message.Value value = message.get(from.name$());
        return !value.isNull() ? value.asList(String.class).stream() : Stream.empty();
    }

    ReelFile reelFile(String type, String subject) throws IOException {
        File file = new File(this.box().datamartReelsDirectory(this.datamart.name(), type), MasterDatamart.ChronosDirectory.normalizePath(subject + ".reel"));
        file.getParentFile().mkdirs();
        return file.exists() ? ReelFile.open((File)file) : ReelFile.create((File)file);
    }

    public static class Reflow
    extends ReelMounter
    implements AutoCloseable {
        private final Map<String, ReelFile.Session> sessions = new HashMap<String, ReelFile.Session>();

        public Reflow(MasterDatamart datamart) {
            super(datamart);
        }

        @Override
        public void mount(Message message) {
            if (message == null) {
                return;
            }
            try {
                MessageEvent event = new MessageEvent(message);
                String key = message.type() + this.subject(event);
                ReelFile.Session session = this.sessions.get(key);
                if (session == null) {
                    session = this.createReelSession(message.type(), this.subject(event));
                    this.sessions.put(key, session);
                }
                this.update(session, event);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }

        private ReelFile.Session createReelSession(String type, String subject) throws IOException {
            return this.reelFile(type, subject).session();
        }

        private void update(ReelFile.Session session, MessageEvent event) throws IOException {
            Datamart datamart = this.datamart.definition();
            List<Reel> reels = datamart.reelList(r -> r.tank().message().name$().equals(event.type()));
            for (Reel reel : reels) {
                session.set(event.ts(), this.group(event, reel.groupSource()), this.mappingAttribute(event.toMessage(), reel));
            }
        }

        @Override
        public void close() {
            for (ReelFile.Session session : this.sessions.values()) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
            }
        }
    }
}

