/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.seal;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileStore;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.event.message.MessageEventReader;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.zit.ZitWriter;
import io.intino.alexandria.zit.model.Period;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Sensor;
import java.io.File;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MeasurementEventSealer {
    private final Datalake datalake;
    private final io.intino.datahub.model.Datalake dlDefinition;

    MeasurementEventSealer(Datalake datalake, io.intino.datahub.model.Datalake dlDefinition) {
        this.datalake = datalake;
        this.dlDefinition = dlDefinition;
    }

    public void seal(Fingerprint fingerprint, List<File> sessions) throws IOException {
        File file = this.datalakeFile(fingerprint);
        try (ZitWriter writer = file.exists() && file.length() > 0L ? new ZitWriter(file) : this.initFile(fingerprint, file);){
            if (writer == null) {
                return;
            }
            this.streamOf(sessions).map(e -> new MeasurementEvent(e.type(), e.ss(), e.ts(), MeasurementEventSealer.magnitudes(e), MeasurementEventSealer.values(e.toMessage()))).forEach(m -> writer.put(m.ts(), m.values()));
        }
    }

    private static String[] magnitudes(MessageEvent e) {
        return e.toMessage().contains("magnitudes") ? (String[])e.toMessage().get("magnitudes").as(String[].class) : (String[])e.toMessage().get("measurements").as(String[].class);
    }

    private ZitWriter initFile(Fingerprint fingerprint, File datalakeFile) {
        String tankName = fingerprint.tank();
        Datalake.Tank tank = this.dlDefinition.tank(t -> t.qn().equals(tankName));
        if (tank == null) {
            return null;
        }
        try {
            return new ZitWriter(datalakeFile, tank.asMeasurement().sensor().name$(), fingerprint.source(), Period.of((int)tank.asMeasurement().period(), (ChronoUnit)tank.asMeasurement().periodScale().chronoUnit()), MeasurementEventSealer.sensorModel(tank));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static String[] sensorModel(Datalake.Tank tank) {
        return (String[])tank.asMeasurement().sensor().magnitudeList().stream().map(m -> m.id() + (String)(m.attributeList().isEmpty() ? "" : ";" + MeasurementEventSealer.toString(m.attributeList()))).toArray(String[]::new);
    }

    private static String toString(List<Sensor.Magnitude.Attribute> attrs) {
        return attrs.stream().map(a -> a.name$() + "=" + a.value()).collect(Collectors.joining(";"));
    }

    private static double[] values(Message message) {
        return Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray();
    }

    private Stream<MessageEvent> streamOf(List<File> files) throws IOException {
        if (files.size() == 1) {
            return new EventStream((Iterator)new MessageEventReader(files.get(0)));
        }
        return EventStream.merge(files.stream().map(file -> {
            try {
                return new EventStream((Iterator)new MessageEventReader((File)files.get(0)));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return Stream.empty();
            }
        }));
    }

    private File datalakeFile(Fingerprint fingerprint) {
        File zimFile = new File(((FileStore)this.datalake.measurementStore()).directory(), fingerprint.tank() + File.separator + fingerprint.source() + File.separator + fingerprint.timetag() + Event.Format.Measurement.extension());
        zimFile.getParentFile().mkdirs();
        return zimFile;
    }
}

