/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Measurement
extends Layer
implements Terminal {
    protected List<Value> valueList = new ArrayList<Value>();

    public Measurement(Node node) {
        super(node);
    }

    public List<Value> valueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public Value value(int index) {
        return this.valueList.get(index);
    }

    public List<Value> valueList(Predicate<Value> predicate) {
        return this.valueList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Value value(Predicate<Value> predicate) {
        return this.valueList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Value>(this.valueList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Measurement$Value")) {
            this.valueList.add((Value)node.as(Value.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Measurement$Value")) {
            this.valueList.remove(node.as(Value.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class Value
    extends Layer
    implements Terminal {
        protected List<Attribute> attributeList = new ArrayList<Attribute>();

        public Value(Node node) {
            super(node);
        }

        public List<Attribute> attributeList() {
            return Collections.unmodifiableList(this.attributeList);
        }

        public Attribute attribute(int index) {
            return this.attributeList.get(index);
        }

        public List<Attribute> attributeList(Predicate<Attribute> predicate) {
            return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Attribute attribute(Predicate<Attribute> predicate) {
            return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Measurement$Value$Attribute")) {
                this.attributeList.add((Attribute)node.as(Attribute.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Measurement$Value$Attribute")) {
                this.attributeList.remove(node.as(Attribute.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static class Attribute
        extends Layer
        implements Terminal {
            protected String value;

            public Attribute(Node node) {
                super(node);
            }

            public String value() {
                return this.value;
            }

            public Attribute value(String value) {
                this.value = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            public NessGraph graph() {
                return (NessGraph)this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Attribute attribute(String value) {
                Attribute newElement = (Attribute)Value.this.core$().graph().concept(Attribute.class).createNode(this.name, Value.this.core$()).as(Attribute.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }
        }

        public class Clear {
            public void attribute(Predicate<Attribute> filter) {
                new ArrayList<Attribute>(Value.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Value value() {
            Value newElement = (Value)Measurement.this.core$().graph().concept(Value.class).createNode(this.name, Measurement.this.core$()).as(Value.class);
            return newElement;
        }
    }

    public class Clear {
        public void value(Predicate<Value> filter) {
            new ArrayList<Value>(Measurement.this.valueList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

