/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Broker;
import io.intino.datahub.model.Component;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Measurement;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Terminal;
import io.intino.datahub.model.rules.Scale;
import io.intino.datahub.model.rules.SnapshotScale;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Entity> entityList = new ArrayList<Entity>();
    private List<Struct> structList = new ArrayList<Struct>();
    private List<Expression> expressionList = new ArrayList<Expression>();
    private List<EntityData> entityDataList = new ArrayList<EntityData>();
    private Broker broker;
    private Datalake datalake;
    private List<Datamart> datamartList = new ArrayList<Datamart>();
    private List<Terminal> terminalList = new ArrayList<Terminal>();
    private List<Namespace> namespaceList = new ArrayList<Namespace>();
    private List<Measurement> measurementList = new ArrayList<Measurement>();
    private List<Resource> resourceList = new ArrayList<Resource>();
    private List<Message> messageList = new ArrayList<Message>();
    private List<Component> componentList = new ArrayList<Component>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.structList = new ArrayList<Struct>(wrapper.structList);
        this.expressionList = new ArrayList<Expression>(wrapper.expressionList);
        this.entityDataList = new ArrayList<EntityData>(wrapper.entityDataList);
        this.broker = wrapper.broker;
        this.datalake = wrapper.datalake;
        this.datamartList = new ArrayList<Datamart>(wrapper.datamartList);
        this.terminalList = new ArrayList<Terminal>(wrapper.terminalList);
        this.namespaceList = new ArrayList<Namespace>(wrapper.namespaceList);
        this.measurementList = new ArrayList<Measurement>(wrapper.measurementList);
        this.resourceList = new ArrayList<Resource>(wrapper.resourceList);
        this.messageList = new ArrayList<Message>(wrapper.messageList);
        this.componentList = new ArrayList<Component>(wrapper.componentList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Struct> structList() {
        return this.structList;
    }

    public List<Expression> expressionList() {
        return this.expressionList;
    }

    public List<EntityData> entityDataList() {
        return this.entityDataList;
    }

    public Broker broker() {
        return this.broker;
    }

    public Datalake datalake() {
        return this.datalake;
    }

    public List<Datamart> datamartList() {
        return this.datamartList;
    }

    public List<Terminal> terminalList() {
        return this.terminalList;
    }

    public List<Namespace> namespaceList() {
        return this.namespaceList;
    }

    public List<Measurement> measurementList() {
        return this.measurementList;
    }

    public List<Resource> resourceList() {
        return this.resourceList;
    }

    public List<Message> messageList() {
        return this.messageList;
    }

    public List<Component> componentList() {
        return this.componentList;
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Struct> structList(Predicate<Struct> filter) {
        return this.structList.stream().filter(filter);
    }

    public Struct struct(int index) {
        return this.structList.get(index);
    }

    public Stream<Expression> expressionList(Predicate<Expression> filter) {
        return this.expressionList.stream().filter(filter);
    }

    public Expression expression(int index) {
        return this.expressionList.get(index);
    }

    public Stream<EntityData> entityDataList(Predicate<EntityData> filter) {
        return this.entityDataList.stream().filter(filter);
    }

    public EntityData entityData(int index) {
        return this.entityDataList.get(index);
    }

    public Stream<Datamart> datamartList(Predicate<Datamart> filter) {
        return this.datamartList.stream().filter(filter);
    }

    public Datamart datamart(int index) {
        return this.datamartList.get(index);
    }

    public Stream<Terminal> terminalList(Predicate<Terminal> filter) {
        return this.terminalList.stream().filter(filter);
    }

    public Terminal terminal(int index) {
        return this.terminalList.get(index);
    }

    public Stream<Namespace> namespaceList(Predicate<Namespace> filter) {
        return this.namespaceList.stream().filter(filter);
    }

    public Namespace namespace(int index) {
        return this.namespaceList.get(index);
    }

    public Stream<Measurement> measurementList(Predicate<Measurement> filter) {
        return this.measurementList.stream().filter(filter);
    }

    public Measurement measurement(int index) {
        return this.measurementList.get(index);
    }

    public Stream<Resource> resourceList(Predicate<Resource> filter) {
        return this.resourceList.stream().filter(filter);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public Stream<Message> messageList(Predicate<Message> filter) {
        return this.messageList.stream().filter(filter);
    }

    public Message message(int index) {
        return this.messageList.get(index);
    }

    public Stream<Component> componentList(Predicate<Component> filter) {
        return this.componentList.stream().filter(filter);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Entity", new Indexer(node -> this.entityList.add((Entity)node.as(Entity.class)), node -> this.entityList.remove(node.as(Entity.class)), () -> this.entityList.clear()));
        map.put("Struct", new Indexer(node -> this.structList.add((Struct)node.as(Struct.class)), node -> this.structList.remove(node.as(Struct.class)), () -> this.structList.clear()));
        map.put("Expression", new Indexer(node -> this.expressionList.add((Expression)node.as(Expression.class)), node -> this.expressionList.remove(node.as(Expression.class)), () -> this.expressionList.clear()));
        map.put("EntityData", new Indexer(node -> this.entityDataList.add((EntityData)node.as(EntityData.class)), node -> this.entityDataList.remove(node.as(EntityData.class)), () -> this.entityDataList.clear()));
        map.put("Broker", new Indexer(node -> {
            this.broker = (Broker)node.as(Broker.class);
        }, node -> {
            this.broker = null;
        }, () -> {
            this.broker = null;
        }));
        map.put("Datalake", new Indexer(node -> {
            this.datalake = (Datalake)node.as(Datalake.class);
        }, node -> {
            this.datalake = null;
        }, () -> {
            this.datalake = null;
        }));
        map.put("Datamart", new Indexer(node -> this.datamartList.add((Datamart)node.as(Datamart.class)), node -> this.datamartList.remove(node.as(Datamart.class)), () -> this.datamartList.clear()));
        map.put("Terminal", new Indexer(node -> this.terminalList.add((Terminal)node.as(Terminal.class)), node -> this.terminalList.remove(node.as(Terminal.class)), () -> this.terminalList.clear()));
        map.put("Namespace", new Indexer(node -> this.namespaceList.add((Namespace)node.as(Namespace.class)), node -> this.namespaceList.remove(node.as(Namespace.class)), () -> this.namespaceList.clear()));
        map.put("Measurement", new Indexer(node -> this.measurementList.add((Measurement)node.as(Measurement.class)), node -> this.measurementList.remove(node.as(Measurement.class)), () -> this.measurementList.clear()));
        map.put("Resource", new Indexer(node -> this.resourceList.add((Resource)node.as(Resource.class)), node -> this.resourceList.remove(node.as(Resource.class)), () -> this.resourceList.clear()));
        map.put("Message", new Indexer(node -> this.messageList.add((Message)node.as(Message.class)), node -> this.messageList.remove(node.as(Message.class)), () -> this.messageList.clear()));
        map.put("Component", new Indexer(node -> this.componentList.add((Component)node.as(Component.class)), node -> this.componentList.remove(node.as(Component.class)), () -> this.componentList.clear()));
        return map;
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Entity entity() {
            Entity newElement = (Entity)((Entity)AbstractGraph.this.graph.createRoot(Entity.class, this.stash, this.name)).a$(Entity.class);
            return newElement;
        }

        public Struct struct() {
            Struct newElement = (Struct)((Struct)AbstractGraph.this.graph.createRoot(Struct.class, this.stash, this.name)).a$(Struct.class);
            return newElement;
        }

        public Broker broker() {
            Broker newElement = (Broker)((Broker)AbstractGraph.this.graph.createRoot(Broker.class, this.stash, this.name)).a$(Broker.class);
            return newElement;
        }

        public Datalake datalake(Scale scale) {
            Datalake newElement = (Datalake)((Datalake)AbstractGraph.this.graph.createRoot(Datalake.class, this.stash, this.name)).a$(Datalake.class);
            newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
            return newElement;
        }

        public Datamart datamart(SnapshotScale scale) {
            Datamart newElement = (Datamart)((Datamart)AbstractGraph.this.graph.createRoot(Datamart.class, this.stash, this.name)).a$(Datamart.class);
            newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
            return newElement;
        }

        public Terminal terminal() {
            Terminal newElement = (Terminal)((Terminal)AbstractGraph.this.graph.createRoot(Terminal.class, this.stash, this.name)).a$(Terminal.class);
            return newElement;
        }

        public Namespace namespace() {
            Namespace newElement = (Namespace)((Namespace)AbstractGraph.this.graph.createRoot(Namespace.class, this.stash, this.name)).a$(Namespace.class);
            return newElement;
        }

        public Measurement measurement() {
            Measurement newElement = (Measurement)((Measurement)AbstractGraph.this.graph.createRoot(Measurement.class, this.stash, this.name)).a$(Measurement.class);
            return newElement;
        }

        public Resource resource() {
            Resource newElement = (Resource)((Resource)AbstractGraph.this.graph.createRoot(Resource.class, this.stash, this.name)).a$(Resource.class);
            return newElement;
        }

        public Message message() {
            Message newElement = (Message)((Message)AbstractGraph.this.graph.createRoot(Message.class, this.stash, this.name)).a$(Message.class);
            return newElement;
        }

        public Component component() {
            Component newElement = (Component)((Component)AbstractGraph.this.graph.createRoot(Component.class, this.stash, this.name)).a$(Component.class);
            return newElement;
        }
    }

    public class Clear {
        public void entity(Predicate<Entity> filter) {
            new ArrayList<Entity>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void struct(Predicate<Struct> filter) {
            new ArrayList<Struct>(AbstractGraph.this.structList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void datamart(Predicate<Datamart> filter) {
            new ArrayList<Datamart>(AbstractGraph.this.datamartList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void terminal(Predicate<Terminal> filter) {
            new ArrayList<Terminal>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void namespace(Predicate<Namespace> filter) {
            new ArrayList<Namespace>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void measurement(Predicate<Measurement> filter) {
            new ArrayList<Measurement>(AbstractGraph.this.measurementList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void resource(Predicate<Resource> filter) {
            new ArrayList<Resource>(AbstractGraph.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void message(Predicate<Message> filter) {
            new ArrayList<Message>(AbstractGraph.this.messageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    static interface Add {
        public void add(Node var1);
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface IndexClear {
        public void clear();
    }
}

