/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.serialization;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.zim.ZimStream;
import io.intino.alexandria.zim.ZimWriter;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.messages.MapMessageMasterDatamart;
import io.intino.datahub.model.Datamart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.stream.Stream;

public class MasterDatamartSerializer {
    public static void serialize(MasterDatamart<?> datamart, File file) throws IOException {
        file.getParentFile().mkdirs();
        MasterDatamartSerializer.serialize(datamart, new FileOutputStream(file));
    }

    public static void serialize(MasterDatamart<?> datamart, OutputStream outputStream) throws IOException {
        if (!datamart.elementType().equals(Message.class)) {
            throw new IllegalArgumentException("Datamart of " + datamart.elementType() + " not supported");
        }
        MasterDatamartSerializer.serializeMessageDatamart(datamart, outputStream);
    }

    private static void serializeMessageDatamart(MasterDatamart<Message> datamart, OutputStream outputStream) throws IOException {
        try (ZimWriter writer = new ZimWriter(outputStream);){
            Iterator messages = datamart.elements().iterator();
            while (messages.hasNext()) {
                writer.write((Message)messages.next());
            }
        }
    }

    public static <T> MasterDatamart<T> deserialize(File file, Datamart definition) throws IOException {
        return MasterDatamartSerializer.deserialize(new FileInputStream(file), definition);
    }

    public static <T> MasterDatamart<T> deserialize(InputStream inputStream, Datamart definition) throws IOException {
        try (ZimStream messages = ZimStream.of((InputStream)inputStream);){
            MapMessageMasterDatamart mapMessageMasterDatamart = new MapMessageMasterDatamart(definition, (Stream<Message>)messages);
            return mapMessageMasterDatamart;
        }
    }

    public static File backupFileOf(Datamart datamart, DataHubBox box) {
        return new File(box.configuration().backupDirectory(), "datamarts/" + datamart.name$() + ".backup");
    }
}

