/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.messages;

import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapMessageMasterDatamart
implements MasterDatamart<Message> {
    private final Datamart definition;
    private final Map<String, Message> messages;
    private final Set<String> subscribedEvents;

    public MapMessageMasterDatamart(Datamart definition) {
        this(definition, new HashMap<String, Message>(128));
    }

    public MapMessageMasterDatamart(Datamart definition, Stream<Message> messages) {
        this.definition = definition;
        this.messages = Collections.synchronizedMap(messages.filter(m -> m.contains("id")).collect(Collectors.toMap(m -> m.get("id").asString(), Function.identity())));
        this.subscribedEvents = definition.entityList().stream().map(Entity::from).filter(Objects::nonNull).map(m -> m.message().name$()).collect(Collectors.toSet());
    }

    public MapMessageMasterDatamart(Datamart definition, Map<String, Message> messages) {
        this.definition = definition;
        this.messages = Collections.synchronizedMap(messages);
        this.subscribedEvents = definition.entityList().stream().map(Entity::from).filter(Objects::nonNull).map(m -> m.message().name$()).collect(Collectors.toSet());
    }

    @Override
    public String name() {
        return this.definition.name$();
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public boolean contains(String id) {
        return this.messages.containsKey(id);
    }

    @Override
    public Message get(String id) {
        return this.messages.get(id);
    }

    @Override
    public void put(String id, Message newMessage) {
        this.messages.put(id, newMessage);
    }

    @Override
    public void putAll(MasterDatamart<Message> other) {
        for (Map.Entry<String, Message> entry : other.toMap().entrySet()) {
            String id = entry.getKey();
            if (this.contains(id)) {
                this.fail(other, entry, id);
            }
            this.put(id, entry.getValue());
        }
    }

    @Override
    public void remove(String id) {
        this.messages.remove(id);
    }

    @Override
    public void clear() {
        this.messages.clear();
    }

    @Override
    public Stream<Message> elements() {
        return this.messages.values().stream();
    }

    @Override
    public Map<String, Message> toMap() {
        return Collections.unmodifiableMap(this.messages);
    }

    @Override
    public Class<Message> elementType() {
        return Message.class;
    }

    @Override
    public Collection<String> subscribedEvents() {
        return this.subscribedEvents;
    }

    private void fail(MasterDatamart<Message> other, Map.Entry<String, Message> entry, String id) {
        Message message = this.get(id);
        if (!message.type().equals(entry.getValue().type())) {
            throw new IllegalStateException("Failed to merge datamart " + other.name() + " into " + this.name() + ": A message with id '" + id + "' is already present.");
        }
    }
}

