/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.rules.DayOfWeek;
import io.intino.datahub.model.rules.SnapshotScale;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public interface MasterDatamart<T> {
    public String name();

    public int size();

    public boolean contains(String var1);

    public T get(String var1);

    public void put(String var1, T var2);

    public void putAll(MasterDatamart<T> var1);

    public void remove(String var1);

    public void clear();

    public Stream<T> elements();

    public Map<String, T> toMap();

    public Class<T> elementType();

    public Collection<String> subscribedEvents();

    public record Snapshot<T>(Timetag timetag, MasterDatamart<T> datamart) {
        public static boolean shouldCreateSnapshot(Timetag timetag, SnapshotScale scale, DayOfWeek firstDayOfWeek) {
            switch (scale) {
                case None: {
                    return false;
                }
                case Year: {
                    return Snapshot.isFirstDayOfYear(timetag);
                }
                case Month: {
                    return Snapshot.isFirstDayOfMonth(timetag);
                }
                case Week: {
                    return Snapshot.isFirstDayOfWeek(timetag, firstDayOfWeek);
                }
                case Day: {
                    return true;
                }
            }
            Logger.error((String)("Unknown snapshot scale for datamarts: " + scale));
            return false;
        }

        private static boolean isFirstDayOfYear(Timetag today) {
            return today.month() == 1 && today.day() == 1;
        }

        private static boolean isFirstDayOfMonth(Timetag today) {
            return today.day() == 1;
        }

        private static boolean isFirstDayOfWeek(Timetag today, DayOfWeek firstDayOfWeek) {
            return today.datetime().getDayOfWeek().name().equalsIgnoreCase(firstDayOfWeek.name());
        }
    }
}

