/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.seal;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.SessionSealer;
import io.intino.datahub.datalake.seal.EventSessionSealer;
import java.io.File;

public class DatahubSessionSealer
implements SessionSealer {
    private final Datalake datalake;
    private final io.intino.datahub.model.Datalake graphDl;
    private final File stageDir;
    private final File treatedDir;

    public DatahubSessionSealer(Datalake datalake, io.intino.datahub.model.Datalake graphDl, File stageDir, File treatedDir) {
        this.datalake = datalake;
        this.graphDl = graphDl;
        this.stageDir = stageDir;
        this.treatedDir = treatedDir;
    }

    public synchronized void seal(SessionSealer.TankFilter tankFilter) {
        try {
            this.treatedDir.mkdirs();
            this.sealEvents(tankFilter);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    private void sealEvents(SessionSealer.TankFilter tankFilter) {
        new EventSessionSealer(this.datalake, this.graphDl, this.stageDir, this.tempDir(), this.treatedDir).seal(t -> this.check(t, tankFilter));
    }

    private boolean check(String tank, SessionSealer.TankFilter tankFilter) {
        return tankFilter.test(this.datalake.messageStore().tank(tank)) || tankFilter.test(this.datalake.measurementStore().tank(tank));
    }

    private File tempDir() {
        File temp = new File(this.stageDir, "temp");
        temp.mkdir();
        return temp;
    }
}

