/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.service.jms;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.jms.MessageReader;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.serialization.MasterDatamartSerializer;
import io.intino.datahub.datamart.serialization.MasterDatamartSnapshots;
import java.io.ByteArrayOutputStream;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.Message;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class DatamartsRequest {
    private final DataHubBox box;

    public DatamartsRequest(DataHubBox box) {
        this.box = box;
    }

    public Stream<Message> accept(Message request) {
        try {
            String content = MessageReader.textFrom((Message)request);
            return this.handleDatamartDownload(content);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> handleDatamartDownload(String request) {
        String[] command = request.split(":", 3);
        if (command.length < 3) {
            return DatamartsRequest.fail("Datamart requests must be like this: datamart:<name>:[snapshots | timetag], but it was " + request);
        }
        String datamartName = command[1].trim();
        String operation = command[2].trim();
        return operation.equals("snapshots") ? this.listAvailableSnapshotsOf(datamartName) : this.downloadDatamart(datamartName, operation);
    }

    private Stream<Message> downloadDatamart(String datamartName, String timetag) {
        if (timetag.isEmpty()) {
            MasterDatamart datamart = this.box.datamarts().get(datamartName);
            return datamart == null ? Stream.empty() : this.downloadDatamart(datamart);
        }
        return MasterDatamartSnapshots.loadMostRecentSnapshotTo(this.box.datamarts().root(), datamartName, this.asTimetag(timetag), this.box.graph()).map(MasterDatamart.Snapshot::datamart).map(this::downloadDatamart).orElse(Stream.empty());
    }

    private Timetag asTimetag(String timetag) {
        return timetag.isEmpty() ? Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day) : Timetag.of((String)timetag);
    }

    private Stream<Message> listAvailableSnapshotsOf(String datamart) {
        List<Timetag> snapshots = MasterDatamartSnapshots.listAvailableSnapshotsOf(this.box.datamarts().root(), datamart);
        if (snapshots.isEmpty()) {
            return Stream.empty();
        }
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setIntProperty("size", snapshots.size());
            message.setText(snapshots.stream().map(Timetag::value).collect(Collectors.joining(",")));
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<Message> downloadDatamart(MasterDatamart<?> datamart) {
        try {
            ActiveMQBytesMessage message = new ActiveMQBytesMessage();
            message.setIntProperty("size", datamart.size());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
            MasterDatamartSerializer.serialize(datamart, outputStream);
            byte[] bytes = outputStream.toByteArray();
            message.writeBytes(bytes);
            message.setIntProperty("content-size", bytes.length);
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    private static <T> Stream<T> fail(String msg) {
        Logger.error((String)msg);
        return Stream.empty();
    }
}

