/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class SealAction {
    public static final String MESSAGE_PREFIX = "Sealed until ";
    private static final Object monitor = new Object();
    public DataHubBox box;

    public SealAction() {
    }

    public SealAction(DataHubBox box) {
        this.box = box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        Object object = monitor;
        synchronized (object) {
            try {
                this.box.brokerSessions().push();
                this.box.lastSeal(Instant.now());
                this.cleanStage();
                this.box.sessionSealer().seal();
                if (this.box.graph().datalake().backup() == null) {
                    this.cleanTreated();
                }
                Logger.info((String)"Finished sealing!");
                return MESSAGE_PREFIX + this.box.lastSeal().toString();
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
                return "Error sealing: " + e.getMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String stage) {
        Object object = monitor;
        synchronized (object) {
            File subStage = new File(this.box.stageDirectory(), stage);
            Instant now = Instant.now();
            if (subStage.exists()) {
                this.box.lastSeal(Instant.now());
                this.box.sessionSealer(subStage).seal();
            }
            Logger.info((String)("Finished sealing of stage " + stage));
            return MESSAGE_PREFIX + now.toString();
        }
    }

    private void cleanStage() {
        for (File file : Objects.requireNonNull(this.box.stageDirectory().listFiles())) {
            if (!file.isDirectory() || Objects.requireNonNull(file.listFiles()).length != 0) continue;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    private void cleanTreated() {
        Instant lastWeek = Instant.now().minus(7L, ChronoUnit.DAYS);
        FileUtils.listFiles((File)this.box.stageDirectory(), (String[])new String[]{"treated"}, (boolean)true).stream().filter(f -> Instant.ofEpochMilli(f.lastModified()).isBefore(lastWeek)).forEach(File::delete);
    }
}

