/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.serialization.MasterDatamartSnapshots;
import io.intino.datahub.model.Datamart;
import java.time.LocalDate;

public class DatamartsSnapshotAction {
    public DataHubBox box;

    public DatamartsSnapshotAction() {
    }

    public DatamartsSnapshotAction(DataHubBox box) {
        this.box = box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Class<DatamartsSnapshotAction> clazz = DatamartsSnapshotAction.class;
        synchronized (DatamartsSnapshotAction.class) {
            Timetag today = Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day);
            this.box.datamarts().datamarts().parallelStream().forEach(datamart -> this.createSnapshotIfNecessary(today, (MasterDatamart<?>)datamart));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void createSnapshotIfNecessary(Timetag today, MasterDatamart<?> datamart) {
        try {
            Datamart definition = this.definitionOf(datamart);
            if (MasterDatamart.Snapshot.shouldCreateSnapshot(today, definition.scale(), definition.firstDayOfWeek())) {
                MasterDatamartSnapshots.saveSnapshot(this.box.datamarts().root(), today, datamart);
            }
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to handle snapshot of " + datamart.name() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private Datamart definitionOf(MasterDatamart<?> datamart) {
        return this.box.graph().datamartList(d -> d.name$().equals(datamart.name())).findFirst().get();
    }
}

