/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.FileSessionSealer;
import io.intino.alexandria.sealing.SessionSealer;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.datahub.box.AbstractBox;
import io.intino.datahub.box.DataHubConfiguration;
import io.intino.datahub.box.service.jms.NessService;
import io.intino.datahub.box.service.scheduling.Sentinels;
import io.intino.datahub.broker.BrokerService;
import io.intino.datahub.broker.jms.JmsBrokerService;
import io.intino.datahub.broker.jms.SSLConfiguration;
import io.intino.datahub.datalake.BrokerSessions;
import io.intino.datahub.datalake.seal.DatahubSessionSealer;
import io.intino.datahub.datamart.MasterDatamartRepository;
import io.intino.datahub.datamart.messages.MapMessageMasterDatamart;
import io.intino.datahub.datamart.messages.MessageMasterDatamartFactory;
import io.intino.datahub.datamart.serialization.MasterDatamartSerializer;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Graph;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;

public class DataHubBox
extends AbstractBox {
    private FileDatalake datalake;
    private BrokerService brokerService;
    private BrokerSessions brokerSessions;
    private NessService nessService;
    private Sentinels sentinels;
    private NessGraph graph;
    private Instant lastSeal;
    private MasterDatamartRepository masterDatamarts;

    public DataHubBox(String[] args) {
        super(args);
    }

    public DataHubBox(DataHubConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        if (o instanceof Graph) {
            this.graph = (NessGraph)((Graph)o).as(NessGraph.class);
            this.injectJmsConfiguration();
        }
        if (o instanceof NessGraph) {
            this.graph = (NessGraph)((Object)o);
            this.injectJmsConfiguration();
        }
        return this;
    }

    public BrokerService brokerService() {
        return this.brokerService;
    }

    public NessGraph graph() {
        return this.graph;
    }

    public BrokerSessions brokerSessions() {
        return this.brokerSessions;
    }

    public SessionSealer sessionSealer() {
        return new DatahubSessionSealer((Datalake)this.datalake, this.graph.datalake(), this.stageDirectory(), this.treatedDirectory());
    }

    private void injectJmsConfiguration() {
        if (this.graph.datalake() != null) {
            this.graph.datalake().path(this.datalakeDirectory().getAbsolutePath());
            if (this.graph.datalake().backup() != null) {
                this.graph.datalake().backup().path(this.configuration.backupDirectory().getAbsolutePath());
            }
        }
        if (this.graph.broker() != null) {
            this.graph.broker().path(this.brokerDirectory().getAbsolutePath());
            this.graph.broker().port(Integer.parseInt(this.configuration.brokerPort()));
            this.graph.broker().secondaryPort(Integer.parseInt(this.configuration.brokerSecondaryPort()));
        }
        if (this.graph.datalake().tank(t -> t.name$().equals("Session")) == null) {
            Message session = this.graph.create("misc", "Session").message();
            this.graph.datalake().create("Session").tank().asMessage(session);
        }
    }

    private File brokerDirectory() {
        return new File(this.configuration.home(), "datahub/broker");
    }

    public File stageDirectory() {
        return new File(this.configuration.home(), "datahub/stage");
    }

    public File treatedDirectory() {
        return new File(this.configuration.home(), "datahub/treated");
    }

    public File mappersDirectory() {
        File mappers = new File(this.configuration.home(), "datahub/mappers");
        mappers.mkdirs();
        return mappers;
    }

    public SessionSealer sessionSealer(File stageDirectory) {
        return new FileSessionSealer(this.datalake, stageDirectory, this.treatedDirectory());
    }

    public MasterDatamartRepository datamarts() {
        return this.masterDatamarts;
    }

    @Override
    public void beforeStart() {
        this.stageDirectory().mkdirs();
        this.loadBrokerService();
        if (this.graph.datalake() != null) {
            this.datalake = new FileDatalake(this.datalakeDirectory());
        }
        if (this.graph.datamartList() != null && !this.graph.datamartList().isEmpty()) {
            this.initMasterDatamarts();
        }
        if (this.graph.broker() != null) {
            this.configureBroker();
            this.nessService = new NessService(this);
        }
        this.sentinels = new Sentinels(this);
    }

    private File datalakeDirectory() {
        return new File(this.configuration.home(), "datalake");
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        return null;
    }

    private void loadBrokerService() {
        if (this.graph.broker() != null && this.graph.broker().implementation() == null) {
            this.graph.broker().implementation(() -> new JmsBrokerService(this, this.brokerStage(), this.configuration.keyStorePath() != null ? this.sslConfiguration() : null));
        }
    }

    private SSLConfiguration sslConfiguration() {
        return new SSLConfiguration(new File(this.configuration.keyStorePath()), new File(this.configuration.trustStorePath()), this.configuration.keyStorePassword().toCharArray(), this.configuration.trustStorePassword().toCharArray());
    }

    private void configureBroker() {
        this.brokerService = this.graph.broker().implementation().get();
        this.brokerSessions = new BrokerSessions(this.brokerStage(), this.stageDirectory());
        try {
            this.brokerService.start();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private File brokerStage() {
        return new File(this.brokerDirectory(), "stage");
    }

    public FileDatalake datalake() {
        return this.datalake;
    }

    public void lastSeal(Instant now) {
        this.lastSeal = now;
    }

    public Instant lastSeal() {
        return this.lastSeal;
    }

    private void initMasterDatamarts() {
        File datamartsRoot = new File(this.configuration.home(), "datahub/datamarts");
        this.masterDatamarts = new MasterDatamartRepository(datamartsRoot);
        MessageMasterDatamartFactory datamartFactory = new MessageMasterDatamartFactory(this, datamartsRoot, (Datalake)this.datalake);
        long start = System.currentTimeMillis();
        for (Datamart datamart : this.graph.datamartList()) {
            this.initDatamart(datamartFactory, datamart);
        }
        Logger.info((String)("MasterDatamarts initialized (" + this.masterDatamarts.size() + ") after " + (System.currentTimeMillis() - start) + " ms"));
        Runtime.getRuntime().addShutdownHook(new Thread(this::saveDatamartBackups, "DatamartBackupsThread"));
    }

    private void saveDatamartBackups() {
        for (Datamart datamart : this.graph.datamartList()) {
            try {
                if (!datamart.saveOnExit()) continue;
                MasterDatamartSerializer.serialize(this.masterDatamarts.get(datamart.name$()), MasterDatamartSerializer.backupFileOf(datamart, this));
            }
            catch (Throwable e) {
                try {
                    Logger.error((String)("Failed to save backup of " + datamart.name$() + ": " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void initDatamart(MessageMasterDatamartFactory datamartFactory, Datamart datamart) {
        try {
            Logger.debug((String)("Initializing MasterDatamart " + datamart.name$() + "..."));
            this.masterDatamarts.put(datamart.name$(), datamartFactory.create(datamart));
            Logger.debug((String)("MasterDatamart " + datamart.name$() + " initialized!"));
        }
        catch (IOException e) {
            Logger.error((String)("Could not initialize datamart " + datamart.name$() + ": " + e.getMessage()), (Throwable)e);
            this.masterDatamarts.put(datamart.name$(), new MapMessageMasterDatamart(datamart));
        }
    }
}

