package io.intino.datahub.model;

import io.intino.magritte.framework.Graph;

public class AbstractGraph extends io.intino.magritte.framework.GraphWrapper {
	protected io.intino.magritte.framework.Graph graph;
	private io.intino.datahub.model.Broker broker;
	private io.intino.datahub.model.Datalake datalake;
	private java.util.List<io.intino.datahub.model.Terminal> terminalList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Namespace> namespaceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Event> eventList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Component> componentList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Data> dataList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Wordbag> wordbagList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Lookup> lookupList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Entity> entityList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Struct> structList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Expression> expressionList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.EntityData> entityDataList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.StructData> structDataList = new java.util.ArrayList<>();

	private java.util.Map<String, Indexer> _index = _fillIndex();

	public AbstractGraph(io.intino.magritte.framework.Graph graph) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
	}

	public AbstractGraph(io.intino.magritte.framework.Graph graph, AbstractGraph wrapper) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
		this.broker = wrapper.broker;
		this.datalake = wrapper.datalake;
		this.terminalList = new java.util.ArrayList<>(wrapper.terminalList);
		this.namespaceList = new java.util.ArrayList<>(wrapper.namespaceList);
		this.eventList = new java.util.ArrayList<>(wrapper.eventList);
		this.componentList = new java.util.ArrayList<>(wrapper.componentList);
		this.dataList = new java.util.ArrayList<>(wrapper.dataList);
		this.wordbagList = new java.util.ArrayList<>(wrapper.wordbagList);
		this.lookupList = new java.util.ArrayList<>(wrapper.lookupList);
		this.entityList = new java.util.ArrayList<>(wrapper.entityList);
		this.structList = new java.util.ArrayList<>(wrapper.structList);
		this.expressionList = new java.util.ArrayList<>(wrapper.expressionList);
		this.entityDataList = new java.util.ArrayList<>(wrapper.entityDataList);
		this.structDataList = new java.util.ArrayList<>(wrapper.structDataList);
	}

	public <T extends io.intino.magritte.framework.GraphWrapper> T a$(Class<T> t) {
		return this.core$().as(t);
	}

    @Override
	public void update() {
		this._index.values().forEach(v -> v.clear());
		graph.rootList().forEach(r -> addNode$(r));
	}

	@Override
	protected void addNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).add(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).add(node);
	}

	@Override
	protected void removeNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).remove(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).remove(node);
	}

	public java.net.URL resourceAsMessage$(String language, String key) {
		return graph.loadResource(graph.i18n().message(language, key));
	}

	public io.intino.datahub.model.Broker broker() {
		return broker;
	}

	public io.intino.datahub.model.Datalake datalake() {
		return datalake;
	}

	public java.util.List<io.intino.datahub.model.Terminal> terminalList() {
		return terminalList;
	}

	public java.util.List<io.intino.datahub.model.Namespace> namespaceList() {
		return namespaceList;
	}

	public java.util.List<io.intino.datahub.model.Event> eventList() {
		return eventList;
	}

	public java.util.List<io.intino.datahub.model.Component> componentList() {
		return componentList;
	}

	public java.util.List<io.intino.datahub.model.Data> dataList() {
		return dataList;
	}

	public java.util.List<io.intino.datahub.model.Wordbag> wordbagList() {
		return wordbagList;
	}

	public java.util.List<io.intino.datahub.model.Lookup> lookupList() {
		return lookupList;
	}

	public java.util.List<io.intino.datahub.model.Entity> entityList() {
		return entityList;
	}

	public java.util.List<io.intino.datahub.model.Struct> structList() {
		return structList;
	}

	public java.util.List<io.intino.datahub.model.Expression> expressionList() {
		return expressionList;
	}

	public java.util.List<io.intino.datahub.model.EntityData> entityDataList() {
		return entityDataList;
	}

	public java.util.List<io.intino.datahub.model.StructData> structDataList() {
		return structDataList;
	}

	public java.util.stream.Stream<io.intino.datahub.model.Terminal> terminalList(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
		return terminalList.stream().filter(filter);
	}

	public io.intino.datahub.model.Terminal terminal(int index) {
		return terminalList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Namespace> namespaceList(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
		return namespaceList.stream().filter(filter);
	}

	public io.intino.datahub.model.Namespace namespace(int index) {
		return namespaceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Event> eventList(java.util.function.Predicate<io.intino.datahub.model.Event> filter) {
		return eventList.stream().filter(filter);
	}

	public io.intino.datahub.model.Event event(int index) {
		return eventList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Component> componentList(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
		return componentList.stream().filter(filter);
	}

	public io.intino.datahub.model.Component component(int index) {
		return componentList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Data> dataList(java.util.function.Predicate<io.intino.datahub.model.Data> filter) {
		return dataList.stream().filter(filter);
	}

	public io.intino.datahub.model.Data data(int index) {
		return dataList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Wordbag> wordbagList(java.util.function.Predicate<io.intino.datahub.model.Wordbag> filter) {
		return wordbagList.stream().filter(filter);
	}

	public io.intino.datahub.model.Wordbag wordbag(int index) {
		return wordbagList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Lookup> lookupList(java.util.function.Predicate<io.intino.datahub.model.Lookup> filter) {
		return lookupList.stream().filter(filter);
	}

	public io.intino.datahub.model.Lookup lookup(int index) {
		return lookupList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Entity> entityList(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
		return entityList.stream().filter(filter);
	}

	public io.intino.datahub.model.Entity entity(int index) {
		return entityList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Struct> structList(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
		return structList.stream().filter(filter);
	}

	public io.intino.datahub.model.Struct struct(int index) {
		return structList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Expression> expressionList(java.util.function.Predicate<io.intino.datahub.model.Expression> filter) {
		return expressionList.stream().filter(filter);
	}

	public io.intino.datahub.model.Expression expression(int index) {
		return expressionList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.EntityData> entityDataList(java.util.function.Predicate<io.intino.datahub.model.EntityData> filter) {
		return entityDataList.stream().filter(filter);
	}

	public io.intino.datahub.model.EntityData entityData(int index) {
		return entityDataList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.StructData> structDataList(java.util.function.Predicate<io.intino.datahub.model.StructData> filter) {
		return structDataList.stream().filter(filter);
	}

	public io.intino.datahub.model.StructData structData(int index) {
		return structDataList.get(index);
	}

	public io.intino.magritte.framework.Graph core$() {
		return graph;
	}

	public io.intino.magritte.framework.utils.I18n i18n$() {
		return graph.i18n();
	}

	public Create create() {
		return new Create("Misc", null);
	}

	public Create create(String stash) {
		return new Create(stash, null);
	}

	public Create create(String stash, String name) {
		return new Create(stash, name);
	}

	public Clear clear() {
		return new Clear();
	}

	public class Create {
		private final String stash;
		private final String name;

		public Create(String stash, String name) {
			this.stash = stash;
			this.name = name;
		}

		public io.intino.datahub.model.Broker broker() {
			io.intino.datahub.model.Broker newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Broker.class, stash, this.name).a$(io.intino.datahub.model.Broker.class);
			return newElement;
		}

		public io.intino.datahub.model.Datalake datalake(io.intino.datahub.model.rules.Scale scale) {
			io.intino.datahub.model.Datalake newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Datalake.class, stash, this.name).a$(io.intino.datahub.model.Datalake.class);
			newElement.core$().set(newElement, "scale", java.util.Collections.singletonList(scale));
			return newElement;
		}

		public io.intino.datahub.model.Terminal terminal() {
			io.intino.datahub.model.Terminal newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Terminal.class, stash, this.name).a$(io.intino.datahub.model.Terminal.class);
			return newElement;
		}

		public io.intino.datahub.model.Namespace namespace() {
			io.intino.datahub.model.Namespace newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Namespace.class, stash, this.name).a$(io.intino.datahub.model.Namespace.class);
			return newElement;
		}

		public io.intino.datahub.model.Event event() {
			io.intino.datahub.model.Event newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Event.class, stash, this.name).a$(io.intino.datahub.model.Event.class);
			return newElement;
		}

		public io.intino.datahub.model.Component component() {
			io.intino.datahub.model.Component newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Component.class, stash, this.name).a$(io.intino.datahub.model.Component.class);
			return newElement;
		}

		public io.intino.datahub.model.Wordbag wordbag() {
			io.intino.datahub.model.Wordbag newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Wordbag.class, stash, this.name).a$(io.intino.datahub.model.Wordbag.class);
			return newElement;
		}

		public io.intino.datahub.model.Lookup lookup(java.lang.String namespace) {
			io.intino.datahub.model.Lookup newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Lookup.class, stash, this.name).a$(io.intino.datahub.model.Lookup.class);
			newElement.core$().set(newElement, "namespace", java.util.Collections.singletonList(namespace));
			return newElement;
		}

		public io.intino.datahub.model.Entity entity() {
			io.intino.datahub.model.Entity newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Entity.class, stash, this.name).a$(io.intino.datahub.model.Entity.class);
			return newElement;
		}

		public io.intino.datahub.model.Struct struct() {
			io.intino.datahub.model.Struct newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Struct.class, stash, this.name).a$(io.intino.datahub.model.Struct.class);
			return newElement;
		}
	}

	public class Clear {
	    public void terminal(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void namespace(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void event(java.util.function.Predicate<io.intino.datahub.model.Event> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.eventList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void component(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void wordbag(java.util.function.Predicate<io.intino.datahub.model.Wordbag> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.wordbagList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void lookup(java.util.function.Predicate<io.intino.datahub.model.Lookup> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.lookupList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void entity(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void struct(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.structList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }
	}


	private java.util.HashMap<String, Indexer> _fillIndex() {
		java.util.HashMap<String, Indexer> map = new java.util.HashMap<>();
		map.put("Broker", new Indexer(node -> broker = node.as(io.intino.datahub.model.Broker.class), node -> broker = null, () -> broker = null));
		map.put("Datalake", new Indexer(node -> datalake = node.as(io.intino.datahub.model.Datalake.class), node -> datalake = null, () -> datalake = null));
		map.put("Terminal", new Indexer(node -> terminalList.add(node.as(io.intino.datahub.model.Terminal.class)), node -> terminalList.remove(node.as(io.intino.datahub.model.Terminal.class)), () -> terminalList.clear()));
		map.put("Namespace", new Indexer(node -> namespaceList.add(node.as(io.intino.datahub.model.Namespace.class)), node -> namespaceList.remove(node.as(io.intino.datahub.model.Namespace.class)), () -> namespaceList.clear()));
		map.put("Event", new Indexer(node -> eventList.add(node.as(io.intino.datahub.model.Event.class)), node -> eventList.remove(node.as(io.intino.datahub.model.Event.class)), () -> eventList.clear()));
		map.put("Component", new Indexer(node -> componentList.add(node.as(io.intino.datahub.model.Component.class)), node -> componentList.remove(node.as(io.intino.datahub.model.Component.class)), () -> componentList.clear()));
		map.put("Data", new Indexer(node -> dataList.add(node.as(io.intino.datahub.model.Data.class)), node -> dataList.remove(node.as(io.intino.datahub.model.Data.class)), () -> dataList.clear()));
		map.put("Wordbag", new Indexer(node -> wordbagList.add(node.as(io.intino.datahub.model.Wordbag.class)), node -> wordbagList.remove(node.as(io.intino.datahub.model.Wordbag.class)), () -> wordbagList.clear()));
		map.put("Lookup", new Indexer(node -> lookupList.add(node.as(io.intino.datahub.model.Lookup.class)), node -> lookupList.remove(node.as(io.intino.datahub.model.Lookup.class)), () -> lookupList.clear()));
		map.put("Entity", new Indexer(node -> entityList.add(node.as(io.intino.datahub.model.Entity.class)), node -> entityList.remove(node.as(io.intino.datahub.model.Entity.class)), () -> entityList.clear()));
		map.put("Struct", new Indexer(node -> structList.add(node.as(io.intino.datahub.model.Struct.class)), node -> structList.remove(node.as(io.intino.datahub.model.Struct.class)), () -> structList.clear()));
		map.put("Expression", new Indexer(node -> expressionList.add(node.as(io.intino.datahub.model.Expression.class)), node -> expressionList.remove(node.as(io.intino.datahub.model.Expression.class)), () -> expressionList.clear()));
		map.put("EntityData", new Indexer(node -> entityDataList.add(node.as(io.intino.datahub.model.EntityData.class)), node -> entityDataList.remove(node.as(io.intino.datahub.model.EntityData.class)), () -> entityDataList.clear()));
		map.put("StructData", new Indexer(node -> structDataList.add(node.as(io.intino.datahub.model.StructData.class)), node -> structDataList.remove(node.as(io.intino.datahub.model.StructData.class)), () -> structDataList.clear()));
		return map;
	}

	public static io.intino.magritte.io.model.Stash[] _language() {
		return new io.intino.magritte.io.model.Stash[]{stash()};
	}

	private static io.intino.magritte.io.model.Stash stash() {
		String content = stash0() + stash1() + stash2() + stash3() + stash4();
		return io.intino.magritte.io.StashDeserializer.stashFrom(java.util.Base64.getDecoder().decode(content));
	}

	private static String stash0() {
		return "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";
	}

	private static String stash1() {
		return "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";
	}

	private static String stash2() {
		return "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";
	}

	private static String stash3() {
		return "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";
	}

	private static String stash4() {
		return "dGEkTG9uZwEAAQABAABTdHJ1Y3REYXRhJExvbucBAAEBAAFTdHJ1Y3REYXRhJFR5cOUBAAJGYWNl9AEAAatpby5pbnRpbm8uZGF0YWh1Yi5tb2RlbC5TdHJ1Y3REYXRhJEJvb2xlYW4BAAEAAQAAU3RydWN0RGF0YSRCb29sZWHuAQABAQABU3RydWN0RGF0YSRUeXDlAQACRmFjZfQBAAGqaW8uaW50aW5vLmRhdGFodWIubW9kZWwuU3RydWN0RGF0YSRTdHJpbmcBAAEAAQAAU3RydWN0RGF0YSRTdHJpbucBAAEBAAFTdHJ1Y3REYXRhJFR5cOUBAAJGYWNl9AEAAahpby5pbnRpbm8uZGF0YWh1Yi5tb2RlbC5TdHJ1Y3REYXRhJERhdGUBAAEAAQAAU3RydWN0RGF0YSREYXTlAQABAQABU3RydWN0RGF0YSRUeXDlAQACRmFjZfQBAIIBAwBmb3JtYfQBAIIDAGRkL01NL3l5efmsaW8uaW50aW5vLmRhdGFodWIubW9kZWwuU3RydWN0RGF0YSREYXRlVGltZQEAAQABAABTdHJ1Y3REYXRhJERhdGVUaW3lAQABAQABU3RydWN0RGF0YSRUeXDlAQACRmFjZfQBAIIBAwBmb3JtYfQBAIIDAGRkL01NL3l5eXkgSEg6bW06c/OraW8uaW50aW5vLmRhdGFodWIubW9kZWwuU3RydWN0RGF0YSRJbnN0YW50AQABAAEAAFN0cnVjdERhdGEkSW5zdGFu9AEAAQEAAVN0cnVjdERhdGEkVHlw5QEAAkZhY2X0AQABqGlvLmludGluby5kYXRhaHViLm1vZGVsLlN0cnVjdERhdGEkV29yZAEAAQABAABTdHJ1Y3REYXRhJFdvcuQBAAEBAAFTdHJ1Y3REYXRhJFR5cOUBAAJGYWNl9AEAAappby5pbnRpbm8uZGF0YWh1Yi5tb2RlbC5TdHJ1Y3REYXRhJEVudGl0eQEAAQABAABTdHJ1Y3REYXRhJEVudGl0+QEAAQEAAVN0cnVjdERhdGEkVHlw5QEAAkZhY2X0AQABAQCPAQIAAgBCcm9rZfICAERhdGFsYWvl/v///w8AVGVybWluYez+////DwBOYW1lc3BhY+X+////DwBFdmVu9P7///8PAENvbXBvbmVu9P7///8PAERhdOH+////DwBXb3JkYmHn/v///w8ATG9va3Xw/v///w8ARW50aXT5/v///w8AU3RydWP0/v///w8ARXhwcmVzc2lv7v7///8PAEVudGl0eURhdOH+////DwBTdHJ1Y3REYXThUHJvdGXvAQABTW9kZWwuc3Rhc+gBAAGA";
	}

	public static class Indexer {
		Add add;
		Remove remove;
		IndexClear clear;

		public Indexer(Add add, Remove remove, IndexClear clear) {
			this.add = add;
			this.remove = remove;
			this.clear = clear;
		}

		void add(io.intino.magritte.framework.Node node) {
			this.add.add(node);
		}

		void remove(io.intino.magritte.framework.Node node) {
			this.remove.remove(node);
		}

		void clear() {
			this.clear.clear();
		}
	}

	interface Add {
		void add(io.intino.magritte.framework.Node node);
	}

	interface Remove {
		void remove(io.intino.magritte.framework.Node node);
	}

	interface IndexClear {
		void clear();
	}
}