package io.intino.datahub.model;

import io.intino.magritte.framework.Graph;

public class AbstractGraph extends io.intino.magritte.framework.GraphWrapper {

	protected io.intino.magritte.framework.Graph graph;
	private io.intino.datahub.model.Broker broker;
	private io.intino.datahub.model.Datalake datalake;
	private java.util.List<io.intino.datahub.model.Terminal> terminalList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Namespace> namespaceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Event> eventList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Component> componentList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Data> dataList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Wordbag> wordbagList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Lookup> lookupList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Entity> entityList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Struct> structList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.EntityData> entityDataList = new java.util.ArrayList<>();

	private java.util.Map<String, Indexer> _index = _fillIndex();

	public AbstractGraph(io.intino.magritte.framework.Graph graph) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
	}

	public AbstractGraph(io.intino.magritte.framework.Graph graph, AbstractGraph wrapper) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
		this.broker = wrapper.broker;
		this.datalake = wrapper.datalake;
		this.terminalList = new java.util.ArrayList<>(wrapper.terminalList);
		this.namespaceList = new java.util.ArrayList<>(wrapper.namespaceList);
		this.eventList = new java.util.ArrayList<>(wrapper.eventList);
		this.componentList = new java.util.ArrayList<>(wrapper.componentList);
		this.dataList = new java.util.ArrayList<>(wrapper.dataList);
		this.wordbagList = new java.util.ArrayList<>(wrapper.wordbagList);
		this.lookupList = new java.util.ArrayList<>(wrapper.lookupList);
		this.entityList = new java.util.ArrayList<>(wrapper.entityList);
		this.structList = new java.util.ArrayList<>(wrapper.structList);
		this.entityDataList = new java.util.ArrayList<>(wrapper.entityDataList);
	}

	public <T extends io.intino.magritte.framework.GraphWrapper> T a$(Class<T> t) {
		return this.core$().as(t);
	}

    @Override
	public void update() {
		this._index.values().forEach(v -> v.clear());
		graph.rootList().forEach(r -> addNode$(r));
	}

	@Override
	protected void addNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).add(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).add(node);
	}

	@Override
	protected void removeNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).remove(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).remove(node);
	}

	public java.net.URL resourceAsMessage$(String language, String key) {
		return graph.loadResource(graph.i18n().message(language, key));
	}

	public io.intino.datahub.model.Broker broker() {
		return broker;
	}

	public io.intino.datahub.model.Datalake datalake() {
		return datalake;
	}

	public java.util.List<io.intino.datahub.model.Terminal> terminalList() {
		return terminalList;
	}

	public java.util.List<io.intino.datahub.model.Namespace> namespaceList() {
		return namespaceList;
	}

	public java.util.List<io.intino.datahub.model.Event> eventList() {
		return eventList;
	}

	public java.util.List<io.intino.datahub.model.Component> componentList() {
		return componentList;
	}

	public java.util.List<io.intino.datahub.model.Data> dataList() {
		return dataList;
	}

	public java.util.List<io.intino.datahub.model.Wordbag> wordbagList() {
		return wordbagList;
	}

	public java.util.List<io.intino.datahub.model.Lookup> lookupList() {
		return lookupList;
	}

	public java.util.List<io.intino.datahub.model.Entity> entityList() {
		return entityList;
	}

	public java.util.List<io.intino.datahub.model.Struct> structList() {
		return structList;
	}

	public java.util.List<io.intino.datahub.model.EntityData> entityDataList() {
		return entityDataList;
	}

	public java.util.stream.Stream<io.intino.datahub.model.Terminal> terminalList(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
		return terminalList.stream().filter(filter);
	}

	public io.intino.datahub.model.Terminal terminal(int index) {
		return terminalList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Namespace> namespaceList(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
		return namespaceList.stream().filter(filter);
	}

	public io.intino.datahub.model.Namespace namespace(int index) {
		return namespaceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Event> eventList(java.util.function.Predicate<io.intino.datahub.model.Event> filter) {
		return eventList.stream().filter(filter);
	}

	public io.intino.datahub.model.Event event(int index) {
		return eventList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Component> componentList(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
		return componentList.stream().filter(filter);
	}

	public io.intino.datahub.model.Component component(int index) {
		return componentList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Data> dataList(java.util.function.Predicate<io.intino.datahub.model.Data> filter) {
		return dataList.stream().filter(filter);
	}

	public io.intino.datahub.model.Data data(int index) {
		return dataList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Wordbag> wordbagList(java.util.function.Predicate<io.intino.datahub.model.Wordbag> filter) {
		return wordbagList.stream().filter(filter);
	}

	public io.intino.datahub.model.Wordbag wordbag(int index) {
		return wordbagList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Lookup> lookupList(java.util.function.Predicate<io.intino.datahub.model.Lookup> filter) {
		return lookupList.stream().filter(filter);
	}

	public io.intino.datahub.model.Lookup lookup(int index) {
		return lookupList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Entity> entityList(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
		return entityList.stream().filter(filter);
	}

	public io.intino.datahub.model.Entity entity(int index) {
		return entityList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Struct> structList(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
		return structList.stream().filter(filter);
	}

	public io.intino.datahub.model.Struct struct(int index) {
		return structList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.EntityData> entityDataList(java.util.function.Predicate<io.intino.datahub.model.EntityData> filter) {
		return entityDataList.stream().filter(filter);
	}

	public io.intino.datahub.model.EntityData entityData(int index) {
		return entityDataList.get(index);
	}

	public io.intino.magritte.framework.Graph core$() {
		return graph;
	}

	public io.intino.magritte.framework.utils.I18n i18n$() {
		return graph.i18n();
	}

	public Create create() {
		return new Create("Misc", null);
	}

	public Create create(String stash) {
		return new Create(stash, null);
	}

	public Create create(String stash, String name) {
		return new Create(stash, name);
	}

	public Clear clear() {
		return new Clear();
	}

	public class Create {
		private final String stash;
		private final String name;

		public Create(String stash, String name) {
			this.stash = stash;
			this.name = name;
		}

		public io.intino.datahub.model.Broker broker() {
			io.intino.datahub.model.Broker newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Broker.class, stash, this.name).a$(io.intino.datahub.model.Broker.class);
			return newElement;
		}

		public io.intino.datahub.model.Datalake datalake(io.intino.datahub.model.rules.Scale scale) {
			io.intino.datahub.model.Datalake newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Datalake.class, stash, this.name).a$(io.intino.datahub.model.Datalake.class);
			newElement.core$().set(newElement, "scale", java.util.Collections.singletonList(scale));
			return newElement;
		}

		public io.intino.datahub.model.Terminal terminal() {
			io.intino.datahub.model.Terminal newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Terminal.class, stash, this.name).a$(io.intino.datahub.model.Terminal.class);
			return newElement;
		}

		public io.intino.datahub.model.Namespace namespace() {
			io.intino.datahub.model.Namespace newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Namespace.class, stash, this.name).a$(io.intino.datahub.model.Namespace.class);
			return newElement;
		}

		public io.intino.datahub.model.Event event() {
			io.intino.datahub.model.Event newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Event.class, stash, this.name).a$(io.intino.datahub.model.Event.class);
			return newElement;
		}

		public io.intino.datahub.model.Component component() {
			io.intino.datahub.model.Component newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Component.class, stash, this.name).a$(io.intino.datahub.model.Component.class);
			return newElement;
		}

		public io.intino.datahub.model.Wordbag wordbag() {
			io.intino.datahub.model.Wordbag newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Wordbag.class, stash, this.name).a$(io.intino.datahub.model.Wordbag.class);
			return newElement;
		}

		public io.intino.datahub.model.Lookup lookup(java.lang.String namespace) {
			io.intino.datahub.model.Lookup newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Lookup.class, stash, this.name).a$(io.intino.datahub.model.Lookup.class);
			newElement.core$().set(newElement, "namespace", java.util.Collections.singletonList(namespace));
			return newElement;
		}

		public io.intino.datahub.model.Entity entity() {
			io.intino.datahub.model.Entity newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Entity.class, stash, this.name).a$(io.intino.datahub.model.Entity.class);
			return newElement;
		}

		public io.intino.datahub.model.Struct struct() {
			io.intino.datahub.model.Struct newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Struct.class, stash, this.name).a$(io.intino.datahub.model.Struct.class);
			return newElement;
		}
	}

	public class Clear {
	    public void terminal(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void namespace(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void event(java.util.function.Predicate<io.intino.datahub.model.Event> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.eventList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void component(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void wordbag(java.util.function.Predicate<io.intino.datahub.model.Wordbag> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.wordbagList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void lookup(java.util.function.Predicate<io.intino.datahub.model.Lookup> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.lookupList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void entity(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void struct(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.structList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }
	}


	private java.util.HashMap<String, Indexer> _fillIndex() {
		java.util.HashMap<String, Indexer> map = new java.util.HashMap<>();
		map.put("Broker", new Indexer(node -> broker = node.as(io.intino.datahub.model.Broker.class), node -> broker = null, () -> broker = null));
		map.put("Datalake", new Indexer(node -> datalake = node.as(io.intino.datahub.model.Datalake.class), node -> datalake = null, () -> datalake = null));
		map.put("Terminal", new Indexer(node -> terminalList.add(node.as(io.intino.datahub.model.Terminal.class)), node -> terminalList.remove(node.as(io.intino.datahub.model.Terminal.class)), () -> terminalList.clear()));
		map.put("Namespace", new Indexer(node -> namespaceList.add(node.as(io.intino.datahub.model.Namespace.class)), node -> namespaceList.remove(node.as(io.intino.datahub.model.Namespace.class)), () -> namespaceList.clear()));
		map.put("Event", new Indexer(node -> eventList.add(node.as(io.intino.datahub.model.Event.class)), node -> eventList.remove(node.as(io.intino.datahub.model.Event.class)), () -> eventList.clear()));
		map.put("Component", new Indexer(node -> componentList.add(node.as(io.intino.datahub.model.Component.class)), node -> componentList.remove(node.as(io.intino.datahub.model.Component.class)), () -> componentList.clear()));
		map.put("Data", new Indexer(node -> dataList.add(node.as(io.intino.datahub.model.Data.class)), node -> dataList.remove(node.as(io.intino.datahub.model.Data.class)), () -> dataList.clear()));
		map.put("Wordbag", new Indexer(node -> wordbagList.add(node.as(io.intino.datahub.model.Wordbag.class)), node -> wordbagList.remove(node.as(io.intino.datahub.model.Wordbag.class)), () -> wordbagList.clear()));
		map.put("Lookup", new Indexer(node -> lookupList.add(node.as(io.intino.datahub.model.Lookup.class)), node -> lookupList.remove(node.as(io.intino.datahub.model.Lookup.class)), () -> lookupList.clear()));
		map.put("Entity", new Indexer(node -> entityList.add(node.as(io.intino.datahub.model.Entity.class)), node -> entityList.remove(node.as(io.intino.datahub.model.Entity.class)), () -> entityList.clear()));
		map.put("Struct", new Indexer(node -> structList.add(node.as(io.intino.datahub.model.Struct.class)), node -> structList.remove(node.as(io.intino.datahub.model.Struct.class)), () -> structList.clear()));
		map.put("EntityData", new Indexer(node -> entityDataList.add(node.as(io.intino.datahub.model.EntityData.class)), node -> entityDataList.remove(node.as(io.intino.datahub.model.EntityData.class)), () -> entityDataList.clear()));
		return map;
	}

	public static class Indexer {
		Add add;
		Remove remove;
		IndexClear clear;

		public Indexer(Add add, Remove remove, IndexClear clear) {
			this.add = add;
			this.remove = remove;
			this.clear = clear;
		}

		void add(io.intino.magritte.framework.Node node) {
			this.add.add(node);
		}

		void remove(io.intino.magritte.framework.Node node) {
			this.remove.remove(node);
		}

		void clear() {
			this.clear.clear();
		}
	}

	interface Add {
		void add(io.intino.magritte.framework.Node node);
	}

	interface Remove {
		void remove(io.intino.magritte.framework.Node node);
	}

	interface IndexClear {
		void clear();
	}
}