package io.intino.datahub.box.ui;
import io.intino.datahub.box.ui.displays.*;
import io.intino.datahub.box.ui.displays.notifiers.*;
import io.intino.datahub.box.ui.displays.requesters.*;
import io.intino.datahub.box.ui.resources.*;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.DataHubConfiguration;

import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class DatalakeInspectorService extends io.intino.alexandria.ui.UI {

	public static void init(UISpark spark, DataHubBox box, PushService pushService, DisplayRouteDispatcher routeDispatcher) {
		DataHubConfiguration configuration = (DataHubConfiguration) box.configuration();
		box.routeManager(routeManager(spark, routeDispatcher));
		spark.route("/push").push(pushService);
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/authenticate-callback/").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		spark.route("/").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		initDisplays(spark, pushService);
	}

	public static void initDisplays(UISpark spark, PushService pushService) {
		initHomeTemplate(spark, pushService);
		initHeader(spark, pushService);
		initHtmlViewer(spark, pushService);
		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.datahub.box.ui.displays.templates.HomeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.datahub.box.ui.displays.templates.Header.class);
		register(HtmlViewerNotifier.class).forDisplay(io.intino.datahub.box.ui.displays.HtmlViewer.class);
	}

    private static void initHomeTemplate(UISpark spark, PushService pushService) {
        spark.route("/hometemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/hometemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/hometemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("hometemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initHeader(UISpark spark, PushService pushService) {
        spark.route("/header/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/header/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/header/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("header", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initHtmlViewer(UISpark spark, PushService pushService) {
        spark.route("/htmlviewer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/htmlviewer/:displayId").post(manager -> new HtmlViewerRequester(manager, notifierProvider()).execute());
        spark.route("/htmlviewer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("htmlviewer", new HtmlViewerPushRequester());

    }
}