package io.intino.datahub.box;

import java.util.Map;
import java.util.HashMap;
import java.io.File;

public class DataHubConfiguration extends io.intino.alexandria.core.BoxConfiguration {

	public DataHubConfiguration(String[] args) {
		super(args);
	}

	public String uiPort() {
		return get("ui_port");
	}

	public File backupDirectory() {
		return get("backup_directory") == null ? null : new File(get("backup_directory"));
	}

	public String brokerPort() {
		return get("broker_port");
	}

	public String brokerSecondaryPort() {
		return get("broker_secondary_port");
	}

	public String masterInstanceName() {
		return get("master_instance_name");
	}

	public String masterPort() {
		return get("master_port");
	}

	public String masterHost() {
		return get("master_host");
	}

	public String masterSerializer() {
		return get("master_serializer");
	}

	public java.io.File home() {
		return new java.io.File(args.getOrDefault("home", System.getProperty("user.home")));
	}
}