package io.intino.datahub.graph;

import io.intino.magritte.framework.Graph;

public class AbstractGraph extends io.intino.magritte.framework.GraphWrapper {

	protected io.intino.magritte.framework.Graph graph;
	private io.intino.datahub.graph.Broker broker;
	private io.intino.datahub.graph.Datalake datalake;
	private java.util.List<io.intino.datahub.graph.Terminal> terminalList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.Namespace> namespaceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.Event> eventList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.Component> componentList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.Data> dataList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.Table> tableList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.WordBag> wordBagList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.graph.Transaction> transactionList = new java.util.ArrayList<>();

	private java.util.Map<String, Indexer> _index = _fillIndex();

	public AbstractGraph(io.intino.magritte.framework.Graph graph) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
	}

	public AbstractGraph(io.intino.magritte.framework.Graph graph, AbstractGraph wrapper) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
		this.broker = wrapper.broker;
		this.datalake = wrapper.datalake;
		this.terminalList = new java.util.ArrayList<>(wrapper.terminalList);
		this.namespaceList = new java.util.ArrayList<>(wrapper.namespaceList);
		this.eventList = new java.util.ArrayList<>(wrapper.eventList);
		this.componentList = new java.util.ArrayList<>(wrapper.componentList);
		this.dataList = new java.util.ArrayList<>(wrapper.dataList);
		this.tableList = new java.util.ArrayList<>(wrapper.tableList);
		this.wordBagList = new java.util.ArrayList<>(wrapper.wordBagList);
		this.transactionList = new java.util.ArrayList<>(wrapper.transactionList);
	}

	public <T extends io.intino.magritte.framework.GraphWrapper> T a$(Class<T> t) {
		return this.core$().as(t);
	}

    @Override
	public void update() {
		this._index.values().forEach(v -> v.clear());
		graph.rootList().forEach(r -> addNode$(r));
	}

	@Override
	protected void addNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).add(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).add(node);
	}

	@Override
	protected void removeNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).remove(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).remove(node);
	}

	public java.net.URL resourceAsMessage$(String language, String key) {
		return graph.loadResource(graph.i18n().message(language, key));
	}

	public io.intino.datahub.graph.Broker broker() {
		return broker;
	}

	public io.intino.datahub.graph.Datalake datalake() {
		return datalake;
	}

	public java.util.List<io.intino.datahub.graph.Terminal> terminalList() {
		return terminalList;
	}

	public java.util.List<io.intino.datahub.graph.Namespace> namespaceList() {
		return namespaceList;
	}

	public java.util.List<io.intino.datahub.graph.Event> eventList() {
		return eventList;
	}

	public java.util.List<io.intino.datahub.graph.Component> componentList() {
		return componentList;
	}

	public java.util.List<io.intino.datahub.graph.Data> dataList() {
		return dataList;
	}

	public java.util.List<io.intino.datahub.graph.Table> tableList() {
		return tableList;
	}

	public java.util.List<io.intino.datahub.graph.WordBag> wordBagList() {
		return wordBagList;
	}

	public java.util.List<io.intino.datahub.graph.Transaction> transactionList() {
		return transactionList;
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Terminal> terminalList(java.util.function.Predicate<io.intino.datahub.graph.Terminal> filter) {
		return terminalList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Terminal terminal(int index) {
		return terminalList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Namespace> namespaceList(java.util.function.Predicate<io.intino.datahub.graph.Namespace> filter) {
		return namespaceList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Namespace namespace(int index) {
		return namespaceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Event> eventList(java.util.function.Predicate<io.intino.datahub.graph.Event> filter) {
		return eventList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Event event(int index) {
		return eventList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Component> componentList(java.util.function.Predicate<io.intino.datahub.graph.Component> filter) {
		return componentList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Component component(int index) {
		return componentList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Data> dataList(java.util.function.Predicate<io.intino.datahub.graph.Data> filter) {
		return dataList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Data data(int index) {
		return dataList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Table> tableList(java.util.function.Predicate<io.intino.datahub.graph.Table> filter) {
		return tableList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Table table(int index) {
		return tableList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.WordBag> wordBagList(java.util.function.Predicate<io.intino.datahub.graph.WordBag> filter) {
		return wordBagList.stream().filter(filter);
	}

	public io.intino.datahub.graph.WordBag wordBag(int index) {
		return wordBagList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.graph.Transaction> transactionList(java.util.function.Predicate<io.intino.datahub.graph.Transaction> filter) {
		return transactionList.stream().filter(filter);
	}

	public io.intino.datahub.graph.Transaction transaction(int index) {
		return transactionList.get(index);
	}

	public io.intino.magritte.framework.Graph core$() {
		return graph;
	}

	public io.intino.magritte.framework.utils.I18n i18n$() {
		return graph.i18n();
	}

	public Create create() {
		return new Create("Misc", null);
	}

	public Create create(String stash) {
		return new Create(stash, null);
	}

	public Create create(String stash, String name) {
		return new Create(stash, name);
	}

	public Clear clear() {
		return new Clear();
	}

	public class Create {
		private final String stash;
		private final String name;

		public Create(String stash, String name) {
			this.stash = stash;
			this.name = name;
		}

		public io.intino.datahub.graph.Broker broker() {
			io.intino.datahub.graph.Broker newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Broker.class, stash, this.name).a$(io.intino.datahub.graph.Broker.class);
			return newElement;
		}

		public io.intino.datahub.graph.Datalake datalake(io.intino.datahub.graph.rules.Scale scale) {
			io.intino.datahub.graph.Datalake newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Datalake.class, stash, this.name).a$(io.intino.datahub.graph.Datalake.class);
			newElement.core$().set(newElement, "scale", java.util.Collections.singletonList(scale));
			return newElement;
		}

		public io.intino.datahub.graph.Terminal terminal() {
			io.intino.datahub.graph.Terminal newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Terminal.class, stash, this.name).a$(io.intino.datahub.graph.Terminal.class);
			return newElement;
		}

		public io.intino.datahub.graph.Namespace namespace() {
			io.intino.datahub.graph.Namespace newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Namespace.class, stash, this.name).a$(io.intino.datahub.graph.Namespace.class);
			return newElement;
		}

		public io.intino.datahub.graph.Event event() {
			io.intino.datahub.graph.Event newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Event.class, stash, this.name).a$(io.intino.datahub.graph.Event.class);
			return newElement;
		}

		public io.intino.datahub.graph.Component component() {
			io.intino.datahub.graph.Component newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Component.class, stash, this.name).a$(io.intino.datahub.graph.Component.class);
			return newElement;
		}

		public io.intino.datahub.graph.Table table() {
			io.intino.datahub.graph.Table newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Table.class, stash, this.name).a$(io.intino.datahub.graph.Table.class);
			return newElement;
		}

		public io.intino.datahub.graph.WordBag wordBag() {
			io.intino.datahub.graph.WordBag newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.WordBag.class, stash, this.name).a$(io.intino.datahub.graph.WordBag.class);
			return newElement;
		}

		public io.intino.datahub.graph.Transaction transaction() {
			io.intino.datahub.graph.Transaction newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.graph.Transaction.class, stash, this.name).a$(io.intino.datahub.graph.Transaction.class);
			return newElement;
		}
	}

	public class Clear {
	    public void terminal(java.util.function.Predicate<io.intino.datahub.graph.Terminal> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void namespace(java.util.function.Predicate<io.intino.datahub.graph.Namespace> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void event(java.util.function.Predicate<io.intino.datahub.graph.Event> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.eventList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void component(java.util.function.Predicate<io.intino.datahub.graph.Component> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void table(java.util.function.Predicate<io.intino.datahub.graph.Table> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.tableList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void wordBag(java.util.function.Predicate<io.intino.datahub.graph.WordBag> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.wordBagList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void transaction(java.util.function.Predicate<io.intino.datahub.graph.Transaction> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.transactionList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }
	}


	private java.util.HashMap<String, Indexer> _fillIndex() {
		java.util.HashMap<String, Indexer> map = new java.util.HashMap<>();
		map.put("Broker", new Indexer(node -> broker = node.as(io.intino.datahub.graph.Broker.class), node -> broker = null, () -> broker = null));
		map.put("Datalake", new Indexer(node -> datalake = node.as(io.intino.datahub.graph.Datalake.class), node -> datalake = null, () -> datalake = null));
		map.put("Terminal", new Indexer(node -> terminalList.add(node.as(io.intino.datahub.graph.Terminal.class)), node -> terminalList.remove(node.as(io.intino.datahub.graph.Terminal.class)), () -> terminalList.clear()));
		map.put("Namespace", new Indexer(node -> namespaceList.add(node.as(io.intino.datahub.graph.Namespace.class)), node -> namespaceList.remove(node.as(io.intino.datahub.graph.Namespace.class)), () -> namespaceList.clear()));
		map.put("Event", new Indexer(node -> eventList.add(node.as(io.intino.datahub.graph.Event.class)), node -> eventList.remove(node.as(io.intino.datahub.graph.Event.class)), () -> eventList.clear()));
		map.put("Component", new Indexer(node -> componentList.add(node.as(io.intino.datahub.graph.Component.class)), node -> componentList.remove(node.as(io.intino.datahub.graph.Component.class)), () -> componentList.clear()));
		map.put("Data", new Indexer(node -> dataList.add(node.as(io.intino.datahub.graph.Data.class)), node -> dataList.remove(node.as(io.intino.datahub.graph.Data.class)), () -> dataList.clear()));
		map.put("Table", new Indexer(node -> tableList.add(node.as(io.intino.datahub.graph.Table.class)), node -> tableList.remove(node.as(io.intino.datahub.graph.Table.class)), () -> tableList.clear()));
		map.put("WordBag", new Indexer(node -> wordBagList.add(node.as(io.intino.datahub.graph.WordBag.class)), node -> wordBagList.remove(node.as(io.intino.datahub.graph.WordBag.class)), () -> wordBagList.clear()));
		map.put("Transaction", new Indexer(node -> transactionList.add(node.as(io.intino.datahub.graph.Transaction.class)), node -> transactionList.remove(node.as(io.intino.datahub.graph.Transaction.class)), () -> transactionList.clear()));
		return map;
	}

	public static class Indexer {
		Add add;
		Remove remove;
		IndexClear clear;

		public Indexer(Add add, Remove remove, IndexClear clear) {
			this.add = add;
			this.remove = remove;
			this.clear = clear;
		}

		void add(io.intino.magritte.framework.Node node) {
			this.add.add(node);
		}

		void remove(io.intino.magritte.framework.Node node) {
			this.remove.remove(node);
		}

		void clear() {
			this.clear.clear();
		}
	}

	interface Add {
		void add(io.intino.magritte.framework.Node node);
	}

	interface Remove {
		void remove(io.intino.magritte.framework.Node node);
	}

	interface IndexClear {
		void clear();
	}
}