/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.graph;

import io.intino.datahub.graph.Broker;
import io.intino.datahub.graph.Component;
import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Namespace;
import io.intino.datahub.graph.Table;
import io.intino.datahub.graph.Terminal;
import io.intino.datahub.graph.Transaction;
import io.intino.datahub.graph.WordBag;
import io.intino.datahub.graph.rules.Scale;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private Broker broker;
    private Datalake datalake;
    private List<Terminal> terminalList = new ArrayList<Terminal>();
    private List<Namespace> namespaceList = new ArrayList<Namespace>();
    private List<Event> eventList = new ArrayList<Event>();
    private List<Component> componentList = new ArrayList<Component>();
    private List<Data> dataList = new ArrayList<Data>();
    private List<Table> tableList = new ArrayList<Table>();
    private List<WordBag> wordBagList = new ArrayList<WordBag>();
    private List<Transaction> transactionList = new ArrayList<Transaction>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
        this.broker = wrapper.broker;
        this.datalake = wrapper.datalake;
        this.terminalList = new ArrayList<Terminal>(wrapper.terminalList);
        this.namespaceList = new ArrayList<Namespace>(wrapper.namespaceList);
        this.eventList = new ArrayList<Event>(wrapper.eventList);
        this.componentList = new ArrayList<Component>(wrapper.componentList);
        this.dataList = new ArrayList<Data>(wrapper.dataList);
        this.tableList = new ArrayList<Table>(wrapper.tableList);
        this.wordBagList = new ArrayList<WordBag>(wrapper.wordBagList);
        this.transactionList = new ArrayList<Transaction>(wrapper.transactionList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Broker broker() {
        return this.broker;
    }

    public Datalake datalake() {
        return this.datalake;
    }

    public List<Terminal> terminalList() {
        return this.terminalList;
    }

    public List<Namespace> namespaceList() {
        return this.namespaceList;
    }

    public List<Event> eventList() {
        return this.eventList;
    }

    public List<Component> componentList() {
        return this.componentList;
    }

    public List<Data> dataList() {
        return this.dataList;
    }

    public List<Table> tableList() {
        return this.tableList;
    }

    public List<WordBag> wordBagList() {
        return this.wordBagList;
    }

    public List<Transaction> transactionList() {
        return this.transactionList;
    }

    public Stream<Terminal> terminalList(Predicate<Terminal> filter) {
        return this.terminalList.stream().filter(filter);
    }

    public Terminal terminal(int index) {
        return this.terminalList.get(index);
    }

    public Stream<Namespace> namespaceList(Predicate<Namespace> filter) {
        return this.namespaceList.stream().filter(filter);
    }

    public Namespace namespace(int index) {
        return this.namespaceList.get(index);
    }

    public Stream<Event> eventList(Predicate<Event> filter) {
        return this.eventList.stream().filter(filter);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public Stream<Component> componentList(Predicate<Component> filter) {
        return this.componentList.stream().filter(filter);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public Stream<Data> dataList(Predicate<Data> filter) {
        return this.dataList.stream().filter(filter);
    }

    public Data data(int index) {
        return this.dataList.get(index);
    }

    public Stream<Table> tableList(Predicate<Table> filter) {
        return this.tableList.stream().filter(filter);
    }

    public Table table(int index) {
        return this.tableList.get(index);
    }

    public Stream<WordBag> wordBagList(Predicate<WordBag> filter) {
        return this.wordBagList.stream().filter(filter);
    }

    public WordBag wordBag(int index) {
        return this.wordBagList.get(index);
    }

    public Stream<Transaction> transactionList(Predicate<Transaction> filter) {
        return this.transactionList.stream().filter(filter);
    }

    public Transaction transaction(int index) {
        return this.transactionList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Broker", new Indexer(node -> {
            this.broker = (Broker)node.as(Broker.class);
        }, node -> {
            this.broker = null;
        }, () -> {
            this.broker = null;
        }));
        map.put("Datalake", new Indexer(node -> {
            this.datalake = (Datalake)node.as(Datalake.class);
        }, node -> {
            this.datalake = null;
        }, () -> {
            this.datalake = null;
        }));
        map.put("Terminal", new Indexer(node -> this.terminalList.add((Terminal)node.as(Terminal.class)), node -> this.terminalList.remove(node.as(Terminal.class)), () -> this.terminalList.clear()));
        map.put("Namespace", new Indexer(node -> this.namespaceList.add((Namespace)node.as(Namespace.class)), node -> this.namespaceList.remove(node.as(Namespace.class)), () -> this.namespaceList.clear()));
        map.put("Event", new Indexer(node -> this.eventList.add((Event)node.as(Event.class)), node -> this.eventList.remove(node.as(Event.class)), () -> this.eventList.clear()));
        map.put("Component", new Indexer(node -> this.componentList.add((Component)node.as(Component.class)), node -> this.componentList.remove(node.as(Component.class)), () -> this.componentList.clear()));
        map.put("Data", new Indexer(node -> this.dataList.add((Data)node.as(Data.class)), node -> this.dataList.remove(node.as(Data.class)), () -> this.dataList.clear()));
        map.put("Table", new Indexer(node -> this.tableList.add((Table)node.as(Table.class)), node -> this.tableList.remove(node.as(Table.class)), () -> this.tableList.clear()));
        map.put("WordBag", new Indexer(node -> this.wordBagList.add((WordBag)node.as(WordBag.class)), node -> this.wordBagList.remove(node.as(WordBag.class)), () -> this.wordBagList.clear()));
        map.put("Transaction", new Indexer(node -> this.transactionList.add((Transaction)node.as(Transaction.class)), node -> this.transactionList.remove(node.as(Transaction.class)), () -> this.transactionList.clear()));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void terminal(Predicate<Terminal> filter) {
            new ArrayList<Terminal>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void namespace(Predicate<Namespace> filter) {
            new ArrayList<Namespace>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void event(Predicate<Event> filter) {
            new ArrayList<Event>(AbstractGraph.this.eventList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void table(Predicate<Table> filter) {
            new ArrayList<Table>(AbstractGraph.this.tableList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void wordBag(Predicate<WordBag> filter) {
            new ArrayList<WordBag>(AbstractGraph.this.wordBagList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void transaction(Predicate<Transaction> filter) {
            new ArrayList<Transaction>(AbstractGraph.this.transactionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Broker broker() {
            Broker newElement = (Broker)((Broker)AbstractGraph.this.graph.createRoot(Broker.class, this.stash, this.name)).a$(Broker.class);
            return newElement;
        }

        public Datalake datalake(Scale scale) {
            Datalake newElement = (Datalake)((Datalake)AbstractGraph.this.graph.createRoot(Datalake.class, this.stash, this.name)).a$(Datalake.class);
            newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
            return newElement;
        }

        public Terminal terminal() {
            Terminal newElement = (Terminal)((Terminal)AbstractGraph.this.graph.createRoot(Terminal.class, this.stash, this.name)).a$(Terminal.class);
            return newElement;
        }

        public Namespace namespace() {
            Namespace newElement = (Namespace)((Namespace)AbstractGraph.this.graph.createRoot(Namespace.class, this.stash, this.name)).a$(Namespace.class);
            return newElement;
        }

        public Event event() {
            Event newElement = (Event)((Event)AbstractGraph.this.graph.createRoot(Event.class, this.stash, this.name)).a$(Event.class);
            return newElement;
        }

        public Component component() {
            Component newElement = (Component)((Component)AbstractGraph.this.graph.createRoot(Component.class, this.stash, this.name)).a$(Component.class);
            return newElement;
        }

        public Table table() {
            Table newElement = (Table)((Table)AbstractGraph.this.graph.createRoot(Table.class, this.stash, this.name)).a$(Table.class);
            return newElement;
        }

        public WordBag wordBag() {
            WordBag newElement = (WordBag)((WordBag)AbstractGraph.this.graph.createRoot(WordBag.class, this.stash, this.name)).a$(WordBag.class);
            return newElement;
        }

        public Transaction transaction() {
            Transaction newElement = (Transaction)((Transaction)AbstractGraph.this.graph.createRoot(Transaction.class, this.stash, this.name)).a$(Transaction.class);
            return newElement;
        }
    }
}

