/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.broker.jms;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.broker.jms.MessageTranslator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.function.Consumer;

class TopicSaver {
    private final File stage;
    private final String tank;
    private final Scale scale;

    TopicSaver(File stage, String tank, Scale scale) {
        this.stage = stage;
        this.tank = tank;
        this.scale = scale;
    }

    Consumer<javax.jms.Message> create() {
        return message -> this.save(MessageTranslator.toInlMessage(message));
    }

    private void save(Message message) {
        try {
            Files.write(this.destination(this.tank, message).toPath(), (message.toString() + "\n\n").getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File destination(String tank, Message message) {
        return new File(this.stage, tank + "#" + this.timetag(message).value() + ".inl");
    }

    private Timetag timetag(Message message) {
        return Timetag.of((LocalDateTime)LocalDateTime.ofInstant(Instant.parse(message.get("ts").data()), ZoneOffset.UTC), (Scale)this.scale);
    }
}

