/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.spark.UIFile;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.ui.displays.HtmlViewer;
import io.intino.datahub.box.ui.displays.templates.AbstractHomeTemplate;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.MapperLoader;
import io.intino.datahub.datalake.regenerator.Regenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.util.List;

public class HomeTemplate
extends AbstractHomeTemplate<DataHubBox> {
    private static String template;
    private HtmlViewer htmlViewer;
    private File file;

    public HomeTemplate(DataHubBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.mapper.value(template);
        this.reviewDialog.onOpen(e -> {
            this.htmlViewer = new HtmlViewer((DataHubBox)this.box());
            this.table.display(this.htmlViewer);
            this.file = this.loadContent();
            this.table.visible(true);
            this.htmlViewer.refresh();
            this.loading.visible(false);
        });
        this.reviewDialog.onClose(event -> {
            if (this.file != null && this.file.exists()) {
                this.file.delete();
            }
        });
    }

    private File loadContent() {
        try {
            File reviewResult = this.calculateReview(this.mapper.value());
            if (reviewResult != null) {
                this.downloadReview.onExecute(event -> this.loadFile(reviewResult));
                if (reviewResult.length() > 2000000L) {
                    this.htmlViewer.content(this.wrap("Review report is too long. Download to inspect it."));
                } else {
                    String content = Files.readString(reviewResult.toPath());
                    this.htmlViewer.content(content.substring(content.indexOf("<table"), content.indexOf("</table>")) + "</table>");
                }
            } else {
                this.htmlViewer.content(this.wrap("Impossible to execute mapper."));
            }
            return reviewResult;
        }
        catch (MapperLoader.CompilationException | IOException ex) {
            this.htmlViewer.content(this.wrap(ex.getMessage()));
            return null;
        }
    }

    private File calculateReview(String mapperCode) throws MapperLoader.CompilationException {
        DataHubBox box = (DataHubBox)this.box();
        try {
            MapperLoader mapperLoader = new MapperLoader(box.configuration().home());
            Mapper mapper = mapperLoader.compileAndLoad(mapperCode);
            List<File> review = new Regenerator(box.datalake(), new File(box.graph().datalake().backup().path(), "sessions"), new File(box.configuration().home(), "reviews")).review(mapper);
            mapperLoader.delete(mapperCode);
            return review.get(0);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            Logger.error((Throwable)ex);
            return null;
        }
    }

    private String wrap(String message) {
        return "<div style=\"text-align:center\">" + message + "</div>";
    }

    private UIFile loadFile(final File reviewResult) {
        return new UIFile(){

            public String label() {
                return reviewResult.getName();
            }

            public InputStream content() {
                try {
                    return new FileInputStream(reviewResult);
                }
                catch (FileNotFoundException ex) {
                    return null;
                }
            }
        };
    }

    static {
        try {
            template = new String(HomeTemplate.class.getResourceAsStream("/mapper.template").readAllBytes());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

