package io.intino.datahub.box.jmx;

import io.intino.datahub.box.DataHubBox;
import java.util.*;
import java.time.*;

public class Service implements ServiceMBean {

	private final DataHubBox box;

	public java.util.List<String> help() {
		List<String> operations = new ArrayList<>();
		operations.addAll(java.util.Arrays.asList(new String[]{"String tanks(): Show tanks", "String backup(): Launch datalake and datahub backup on demand", "String seal(): Launch datalake sealing", "String restoreDatalake(String timetag): Restore datalake to timetag parameter. Timetag is in scale of days", "String mappers(): Shows a list of available mappers", "String review(String mapper): Review datalake using a defined mapper. Returns a file containing the efects of passing the mapper", "String revise(String mapper): Review datalake using a defined mapper"}));
		return operations;
	}

	public Service(DataHubBox box) {
		this.box = box;
	}

	public String tanks() {
		io.intino.datahub.box.actions.TanksAction action = new io.intino.datahub.box.actions.TanksAction();
		action.box = box;
		return action.execute();
	}

	public String backup() {
		io.intino.datahub.box.actions.BackupAction action = new io.intino.datahub.box.actions.BackupAction();
		action.box = box;
		return action.execute();
	}

	public String seal() {
		io.intino.datahub.box.actions.SealAction action = new io.intino.datahub.box.actions.SealAction();
		action.box = box;
		return action.execute();
	}

	public String restoreDatalake(String timetag) {
		io.intino.datahub.box.actions.RestoreDatalakeAction action = new io.intino.datahub.box.actions.RestoreDatalakeAction();
		action.box = box;
		action.timetag = timetag;
		return action.execute();
	}

	public String mappers() {
		io.intino.datahub.box.actions.MappersAction action = new io.intino.datahub.box.actions.MappersAction();
		action.box = box;
		return action.execute();
	}

	public String review(String mapper) {
		io.intino.datahub.box.actions.ReviewAction action = new io.intino.datahub.box.actions.ReviewAction();
		action.box = box;
		action.mapper = mapper;
		return action.execute();
	}

	public String revise(String mapper) {
		io.intino.datahub.box.actions.ReviseAction action = new io.intino.datahub.box.actions.ReviseAction();
		action.box = box;
		action.mapper = mapper;
		return action.execute();
	}
}