/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.graph;

import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.NessGraph;
import io.intino.magritte.framework.Expression;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Namespace
extends Layer
implements Terminal {
    protected Expression<String> qn;
    protected List<Namespace> namespaceList = new ArrayList<Namespace>();
    protected List<Event> eventList = new ArrayList<Event>();

    public Namespace(Node node) {
        super(node);
    }

    public String qn() {
        return (String)this.qn.value();
    }

    public Namespace qn(Expression<String> value) {
        this.qn = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public List<Namespace> namespaceList() {
        return Collections.unmodifiableList(this.namespaceList);
    }

    public Namespace namespace(int index) {
        return this.namespaceList.get(index);
    }

    public List<Namespace> namespaceList(Predicate<Namespace> predicate) {
        return this.namespaceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Namespace namespace(Predicate<Namespace> predicate) {
        return this.namespaceList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Event> eventList() {
        return Collections.unmodifiableList(this.eventList);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public List<Event> eventList(Predicate<Event> predicate) {
        return this.eventList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Event event(Predicate<Event> predicate) {
        return this.eventList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Namespace>(this.namespaceList).forEach(c -> components.add(c.core$()));
        new ArrayList<Event>(this.eventList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("qn", new ArrayList<Expression<String>>(Collections.singletonList(this.qn)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Namespace")) {
            this.namespaceList.add((Namespace)node.as(Namespace.class));
        }
        if (node.is("Event")) {
            this.eventList.add((Event)node.as(Event.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Namespace")) {
            this.namespaceList.remove(node.as(Namespace.class));
        }
        if (node.is("Event")) {
            this.eventList.remove(node.as(Event.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("qn")) {
            this.qn = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("qn")) {
            this.qn = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public class Clear {
        public void namespace(Predicate<Namespace> filter) {
            new ArrayList<Namespace>(Namespace.this.namespaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void event(Predicate<Event> filter) {
            new ArrayList<Event>(Namespace.this.eventList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Namespace namespace() {
            Namespace newElement = (Namespace)Namespace.this.core$().graph().concept(Namespace.class).createNode(this.name, Namespace.this.core$()).as(Namespace.class);
            return newElement;
        }

        public Event event() {
            Event newElement = (Event)Namespace.this.core$().graph().concept(Event.class).createNode(this.name, Namespace.this.core$()).as(Event.class);
            return newElement;
        }
    }
}

