/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.broker.jms;

import io.intino.alexandria.logger.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.command.ActiveMQDestination;

class AdvisoryManager {
    private final Broker broker;
    private HashMap<String, Info> info = new HashMap();

    AdvisoryManager(Broker broker) {
        this.broker = broker;
    }

    void start(Session session) {
        try {
            List<ActiveMQDestination> destinations = this.destinations();
            for (ActiveMQDestination destination : destinations) {
                this.info.put(destination.getPhysicalName(), new Info());
                Topic advisory = session.createTopic(AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)destination).getPhysicalName());
                MessageConsumer consumer = session.createConsumer((Destination)advisory);
                consumer.setMessageListener(message -> {
                    Info info = this.info.get(destination.getPhysicalName());
                    info.consumers = this.consumers(message);
                    info.producers = this.producers(message);
                });
            }
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
        }
    }

    private List<ActiveMQDestination> destinations() {
        try {
            return Arrays.stream(this.broker.getDestinations()).filter(n -> !n.getPhysicalName().contains("ActiveMQ.Advisory")).collect(Collectors.toList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public List<String> topicsInfo() {
        try {
            List destinations = Arrays.stream(this.broker.getDestinations()).filter(d -> !d.getPhysicalName().contains("ActiveMQ.Advisory")).collect(Collectors.toList());
            return destinations.stream().map(d -> d.getPhysicalName() + " Consumers:" + this.consumersOf((ActiveMQDestination)d) + " Producers:" + this.producersOf((ActiveMQDestination)d) + " Enqueued:" + this.enqueuedMessageOf((ActiveMQDestination)d) + " Enqueued:" + this.dequeuedMessageOf((ActiveMQDestination)d)).collect(Collectors.toList());
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public int consumersOf(ActiveMQDestination d) {
        return this.info.get(d.getPhysicalName()) == null ? 0 : this.info.get((Object)d.getPhysicalName()).consumers;
    }

    public int producersOf(ActiveMQDestination d) {
        return this.info.get(d.getPhysicalName()) == null ? 0 : this.info.get((Object)d.getPhysicalName()).producers;
    }

    public int enqueuedMessageOf(ActiveMQDestination d) {
        return 0;
    }

    public int dequeuedMessageOf(ActiveMQDestination d) {
        return 0;
    }

    private int consumers(Message message) {
        try {
            return message.getIntProperty("consumerCount");
        }
        catch (NumberFormatException | JMSException e) {
            return 0;
        }
    }

    private int producers(Message message) {
        try {
            return message.getIntProperty("producerCount");
        }
        catch (NumberFormatException | JMSException e) {
            return 0;
        }
    }

    private class Info {
        int consumers = 0;
        int producers = 0;
        int enqueued = 0;
        int dequeued = 0;

        private Info() {
        }
    }
}

