/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class SealAction {
    private static AtomicBoolean started = new AtomicBoolean(false);
    public DataHubBox box;

    public SealAction() {
    }

    public SealAction(DataHubBox box) {
        this.box = box;
    }

    public synchronized String execute() {
        if (started.get()) {
            return "Sealing already started";
        }
        started.set(true);
        this.box.brokerSessions().push();
        this.cleanStage();
        this.box.sessionSealer().seal();
        Logger.info((String)"Finished sealing!");
        started.set(false);
        return "Finished sealing!";
    }

    public synchronized void execute(String stage) {
        if (started.get()) {
            return;
        }
        started.set(true);
        File subStage = new File(this.box.stageDirectory(), stage);
        if (subStage.exists()) {
            this.box.sessionSealer(subStage).seal();
        }
        Logger.info((String)("Finished sealing of stage " + stage));
        started.set(false);
    }

    private void cleanStage() {
        for (File file : Objects.requireNonNull(this.box.stageDirectory().listFiles())) {
            if (!file.isDirectory() || Objects.requireNonNull(file.listFiles()).length != 0) continue;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }
}

