package io.intino.datahub.box.jmx;

import io.intino.alexandria.jmx.Description;
import io.intino.alexandria.jmx.Parameters;

import java.util.*;
import java.time.*;

public interface ServiceMBean {

	@Description("Shows information about the available operations")
	@Parameters({})
	java.util.List<String> help();

	@Description("Show tanks")
	@Parameters({})
	String tanks();

	@Description("Launch datalake and datahub backup on demand")
	@Parameters({})
	String backup();

	@Description("Launch datalake sealing")
	@Parameters({})
	String seal();

	@Description("Restore datalake to timetag parameter. Timetag is in scale of days")
	@Parameters({"timetag"})
	String restoreDatalake(String timetag);

	@Description("Shows a list of available mappers")
	@Parameters({})
	String mappers();

	@Description("Review datalake using a defined mapper. Returns a file containing the efects of passing the mapper")
	@Parameters({"mapper"})
	String review(String mapper);

	@Description("Review datalake using a defined mapper")
	@Parameters({"mapper"})
	String revise(String mapper);
}