/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Sensor
extends Layer
implements Terminal {
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Magnitude> magnitudeList = new ArrayList<Magnitude>();

    public Sensor(Node node) {
        super(node);
    }

    public List<Attribute> attributeList() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public Attribute attribute(int index) {
        return this.attributeList.get(index);
    }

    public List<Attribute> attributeList(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Attribute attribute(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Magnitude> magnitudeList() {
        return Collections.unmodifiableList(this.magnitudeList);
    }

    public Magnitude magnitude(int index) {
        return this.magnitudeList.get(index);
    }

    public List<Magnitude> magnitudeList(Predicate<Magnitude> predicate) {
        return this.magnitudeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Magnitude magnitude(Predicate<Magnitude> predicate) {
        return this.magnitudeList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
        new ArrayList<Magnitude>(this.magnitudeList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Sensor$Attribute")) {
            this.attributeList.add((Attribute)node.as(Attribute.class));
        }
        if (node.is("Sensor$Magnitude")) {
            this.magnitudeList.add((Magnitude)node.as(Magnitude.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Sensor$Attribute")) {
            this.attributeList.remove(node.as(Attribute.class));
        }
        if (node.is("Sensor$Magnitude")) {
            this.magnitudeList.remove(node.as(Magnitude.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class Attribute
    extends Layer
    implements Terminal {
        protected String value;

        public Attribute(Node node) {
            super(node);
        }

        public String value() {
            return this.value;
        }

        public Attribute value(String value) {
            this.value = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Magnitude
    extends Layer
    implements Terminal {
        protected String id;
        protected List<Attribute> attributeList = new ArrayList<Attribute>();

        public Magnitude(Node node) {
            super(node);
        }

        public String id() {
            return this.id;
        }

        public Magnitude id(String value) {
            this.id = value;
            return this;
        }

        public List<Attribute> attributeList() {
            return Collections.unmodifiableList(this.attributeList);
        }

        public Attribute attribute(int index) {
            return this.attributeList.get(index);
        }

        public List<Attribute> attributeList(Predicate<Attribute> predicate) {
            return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Attribute attribute(Predicate<Attribute> predicate) {
            return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Sensor$Magnitude$Attribute")) {
                this.attributeList.add((Attribute)node.as(Attribute.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Sensor$Magnitude$Attribute")) {
                this.attributeList.remove(node.as(Attribute.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("id")) {
                this.id = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("id")) {
                this.id = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static class Attribute
        extends Layer
        implements Terminal {
            protected String value;

            public Attribute(Node node) {
                super(node);
            }

            public String value() {
                return this.value;
            }

            public Attribute value(String value) {
                this.value = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            public NessGraph graph() {
                return (NessGraph)this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Attribute attribute(String value) {
                Attribute newElement = (Attribute)Magnitude.this.core$().graph().concept(Attribute.class).createNode(this.name, Magnitude.this.core$()).as(Attribute.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }
        }

        public class Clear {
            public void attribute(Predicate<Attribute> filter) {
                new ArrayList<Attribute>(Magnitude.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Attribute attribute(String value) {
            Attribute newElement = (Attribute)Sensor.this.core$().graph().concept(Attribute.class).createNode(this.name, Sensor.this.core$()).as(Attribute.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public Magnitude magnitude(String id) {
            Magnitude newElement = (Magnitude)Sensor.this.core$().graph().concept(Magnitude.class).createNode(this.name, Sensor.this.core$()).as(Magnitude.class);
            newElement.core$().set((Layer)newElement, "id", Collections.singletonList(id));
            return newElement;
        }
    }

    public class Clear {
        public void attribute(Predicate<Attribute> filter) {
            new ArrayList<Attribute>(Sensor.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void magnitude(Predicate<Magnitude> filter) {
            new ArrayList<Magnitude>(Sensor.this.magnitudeList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

