/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Indicator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class IndicatorFile {
    private final File file;

    public static IndicatorFile of(File file) {
        return new IndicatorFile(file);
    }

    public IndicatorFile(File file) {
        this.file = file;
    }

    public IndicatorFile(String file) {
        this(new File(file));
    }

    public File file() {
        return this.file;
    }

    public Indicator get() throws IOException {
        HashMap<String, Indicator.Shot> shots;
        if (!this.file.exists()) {
            return new Indicator(new HashMap<String, Indicator.Shot>());
        }
        try (ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.file)));){
            int size = stream.readInt();
            shots = new HashMap<String, Indicator.Shot>(size);
            for (int i = 0; i < size; ++i) {
                shots.put(stream.readUTF(), new Indicator.Shot(Instant.ofEpochMilli(stream.readLong()), stream.readDouble()));
            }
        }
        return new Indicator(shots);
    }

    public void save(Indicator indicator) throws IOException {
        this.file.getParentFile().mkdirs();
        try (ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));){
            stream.writeInt(indicator.shots().size());
            for (Map.Entry<String, Indicator.Shot> entry : indicator.shots().entrySet()) {
                stream.writeUTF(entry.getKey());
                stream.writeLong(entry.getValue().ts().toEpochMilli());
                stream.writeDouble(entry.getValue().value());
            }
        }
    }
}

