/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class Expression
extends Layer
implements Terminal {
    protected Private _private;
    protected Getter _getter;
    protected DoubleGetter _doubleGetter;
    protected IntegerGetter _integerGetter;
    protected LongGetter _longGetter;
    protected BooleanGetter _booleanGetter;
    protected TextGetter _textGetter;
    protected DateGetter _dateGetter;
    protected DateTimeGetter _dateTimeGetter;
    protected InstantGetter _instantGetter;
    protected Function _function;
    protected Routine _routine;

    public Expression(Node node) {
        super(node);
    }

    public InstantGetter asInstantGetter() {
        return (InstantGetter)this.a$(InstantGetter.class);
    }

    public InstantGetter asInstantGetter(String expression) {
        InstantGetter newElement = (InstantGetter)this.core$().addAspect(InstantGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isInstantGetter() {
        return this.core$().is(InstantGetter.class);
    }

    public void removeInstantGetter() {
        this.core$().removeAspect(InstantGetter.class);
    }

    public DoubleGetter asDoubleGetter() {
        return (DoubleGetter)this.a$(DoubleGetter.class);
    }

    public DoubleGetter asDoubleGetter(String expression) {
        DoubleGetter newElement = (DoubleGetter)this.core$().addAspect(DoubleGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isDoubleGetter() {
        return this.core$().is(DoubleGetter.class);
    }

    public void removeDoubleGetter() {
        this.core$().removeAspect(DoubleGetter.class);
    }

    public Getter asGetter() {
        return (Getter)this.a$(Getter.class);
    }

    public boolean isGetter() {
        return this.core$().is(Getter.class);
    }

    public DateTimeGetter asDateTimeGetter() {
        return (DateTimeGetter)this.a$(DateTimeGetter.class);
    }

    public DateTimeGetter asDateTimeGetter(String expression) {
        DateTimeGetter newElement = (DateTimeGetter)this.core$().addAspect(DateTimeGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isDateTimeGetter() {
        return this.core$().is(DateTimeGetter.class);
    }

    public void removeDateTimeGetter() {
        this.core$().removeAspect(DateTimeGetter.class);
    }

    public Function asFunction() {
        return (Function)this.a$(Function.class);
    }

    public Function asFunction(String expression) {
        Function newElement = (Function)this.core$().addAspect(Function.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isFunction() {
        return this.core$().is(Function.class);
    }

    public void removeFunction() {
        this.core$().removeAspect(Function.class);
    }

    public Routine asRoutine() {
        return (Routine)this.a$(Routine.class);
    }

    public Routine asRoutine(String expression) {
        Routine newElement = (Routine)this.core$().addAspect(Routine.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isRoutine() {
        return this.core$().is(Routine.class);
    }

    public void removeRoutine() {
        this.core$().removeAspect(Routine.class);
    }

    public IntegerGetter asIntegerGetter() {
        return (IntegerGetter)this.a$(IntegerGetter.class);
    }

    public IntegerGetter asIntegerGetter(String expression) {
        IntegerGetter newElement = (IntegerGetter)this.core$().addAspect(IntegerGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isIntegerGetter() {
        return this.core$().is(IntegerGetter.class);
    }

    public void removeIntegerGetter() {
        this.core$().removeAspect(IntegerGetter.class);
    }

    public LongGetter asLongGetter() {
        return (LongGetter)this.a$(LongGetter.class);
    }

    public LongGetter asLongGetter(String expression) {
        LongGetter newElement = (LongGetter)this.core$().addAspect(LongGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isLongGetter() {
        return this.core$().is(LongGetter.class);
    }

    public void removeLongGetter() {
        this.core$().removeAspect(LongGetter.class);
    }

    public Private asPrivate() {
        Layer as = this.a$(Private.class);
        return as != null ? (Private)as : (Private)this.core$().addAspect(Private.class);
    }

    public boolean isPrivate() {
        return this.core$().is(Private.class);
    }

    public void removePrivate() {
        this.core$().removeAspect(Private.class);
    }

    public TextGetter asTextGetter() {
        return (TextGetter)this.a$(TextGetter.class);
    }

    public TextGetter asTextGetter(String expression) {
        TextGetter newElement = (TextGetter)this.core$().addAspect(TextGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isTextGetter() {
        return this.core$().is(TextGetter.class);
    }

    public void removeTextGetter() {
        this.core$().removeAspect(TextGetter.class);
    }

    public DateGetter asDateGetter() {
        return (DateGetter)this.a$(DateGetter.class);
    }

    public DateGetter asDateGetter(String expression) {
        DateGetter newElement = (DateGetter)this.core$().addAspect(DateGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isDateGetter() {
        return this.core$().is(DateGetter.class);
    }

    public void removeDateGetter() {
        this.core$().removeAspect(DateGetter.class);
    }

    public BooleanGetter asBooleanGetter() {
        return (BooleanGetter)this.a$(BooleanGetter.class);
    }

    public BooleanGetter asBooleanGetter(String expression) {
        BooleanGetter newElement = (BooleanGetter)this.core$().addAspect(BooleanGetter.class);
        newElement.core$().set((Layer)newElement, "expression", Collections.singletonList(expression));
        return newElement;
    }

    public boolean isBooleanGetter() {
        return this.core$().is(BooleanGetter.class);
    }

    public void removeBooleanGetter() {
        this.core$().removeAspect(BooleanGetter.class);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(this, null);
    }

    public Create create(String name) {
        return new Create(this, name);
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class InstantGetter
    extends Getter
    implements Terminal {
        public InstantGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class DoubleGetter
    extends Getter
    implements Terminal {
        public DoubleGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static abstract class Getter
    extends Layer
    implements Terminal {
        protected String expression;
        protected Expression _expression;

        public Getter(Node node) {
            super(node);
        }

        public String expression() {
            return this.expression;
        }

        public Getter expression(String value) {
            this.expression = value;
            return this;
        }

        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("expression", new ArrayList<String>(Collections.singletonList(this.expression)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("expression")) {
                this.expression = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("expression")) {
                this.expression = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Expression) {
                this._expression = (Expression)layer;
            }
        }

        public Create create() {
            return new Create(this, null);
        }

        public Create create(String name) {
            return new Create(this, name);
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(Getter this$0, String name) {
                this.name = name;
            }
        }
    }

    public static class DateTimeGetter
    extends Getter
    implements Terminal {
        public DateTimeGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Function
    extends Layer
    implements Terminal {
        protected String expression;
        protected ReturnType returnType;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected Expression _expression;

        public Function(Node node) {
            super(node);
        }

        public String expression() {
            return this.expression;
        }

        public Function expression(String value) {
            this.expression = value;
            return this;
        }

        public ReturnType returnType() {
            return this.returnType;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Parameter parameter(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).findFirst().orElse(null);
        }

        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.returnType != null) {
                components.add(this.returnType.core$());
            }
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("expression", new ArrayList<String>(Collections.singletonList(this.expression)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Expression$Function$ReturnType")) {
                this.returnType = (ReturnType)node.as(ReturnType.class);
            }
            if (node.is("Expression$Function$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Expression$Function$ReturnType")) {
                this.returnType = null;
            }
            if (node.is("Expression$Function$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("expression")) {
                this.expression = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("expression")) {
                this.expression = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Expression) {
                this._expression = (Expression)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static class ReturnType
        extends EntityData
        implements Terminal {
            public ReturnType(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public NessGraph graph() {
                return (NessGraph)this.core$().graph().as(NessGraph.class);
            }
        }

        public static class Parameter
        extends EntityData
        implements Terminal {
            public Parameter(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public NessGraph graph() {
                return (NessGraph)this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public ReturnType returnType() {
                ReturnType newElement = (ReturnType)Function.this.core$().graph().concept(ReturnType.class).createNode(this.name, Function.this.core$()).as(ReturnType.class);
                return newElement;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Function.this.core$().graph().concept(Parameter.class).createNode(this.name, Function.this.core$()).as(Parameter.class);
                return newElement;
            }
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Function.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Routine
    extends Layer
    implements Terminal {
        protected String expression;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected Expression _expression;

        public Routine(Node node) {
            super(node);
        }

        public String expression() {
            return this.expression;
        }

        public Routine expression(String value) {
            this.expression = value;
            return this;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Parameter parameter(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).findFirst().orElse(null);
        }

        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("expression", new ArrayList<String>(Collections.singletonList(this.expression)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Expression$Routine$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Expression$Routine$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("expression")) {
                this.expression = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("expression")) {
                this.expression = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Expression) {
                this._expression = (Expression)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static class Parameter
        extends EntityData
        implements Terminal {
            public Parameter(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public NessGraph graph() {
                return (NessGraph)this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Routine.this.core$().graph().concept(Parameter.class).createNode(this.name, Routine.this.core$()).as(Parameter.class);
                return newElement;
            }
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Routine.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class IntegerGetter
    extends Getter
    implements Terminal {
        public IntegerGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class LongGetter
    extends Getter
    implements Terminal {
        public LongGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Private
    extends Layer
    implements Terminal {
        protected Expression _expression;

        public Private(Node node) {
            super(node);
        }

        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Expression) {
                this._expression = (Expression)layer;
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class TextGetter
    extends Getter
    implements Terminal {
        public TextGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class DateGetter
    extends Getter
    implements Terminal {
        public DateGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class BooleanGetter
    extends Getter
    implements Terminal {
        public BooleanGetter(Node node) {
            super(node);
        }

        @Override
        public Expression asExpression() {
            return (Expression)this.a$(Expression.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this._expression.core$().load((Layer)this._expression, name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this._expression.core$().set((Layer)this._expression, name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public class Create {
        protected final String name;

        public Create(Expression this$0, String name) {
            this.name = name;
        }
    }
}

