/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Broker;
import io.intino.datahub.model.Component;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Terminal;
import io.intino.datahub.model.rules.Scale;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import io.intino.magritte.io.StashDeserializer;
import io.intino.magritte.io.model.Stash;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private Broker broker;
    private Datalake datalake;
    private List<Datamart> datamartList = new ArrayList<Datamart>();
    private List<Terminal> terminalList = new ArrayList<Terminal>();
    private List<Namespace> namespaceList = new ArrayList<Namespace>();
    private List<Sensor> sensorList = new ArrayList<Sensor>();
    private List<Resource> resourceList = new ArrayList<Resource>();
    private List<Message> messageList = new ArrayList<Message>();
    private List<Component> componentList = new ArrayList<Component>();
    private List<Entity> entityList = new ArrayList<Entity>();
    private List<Struct> structList = new ArrayList<Struct>();
    private List<Expression> expressionList = new ArrayList<Expression>();
    private List<EntityData> entityDataList = new ArrayList<EntityData>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
        this.broker = wrapper.broker;
        this.datalake = wrapper.datalake;
        this.datamartList = new ArrayList<Datamart>(wrapper.datamartList);
        this.terminalList = new ArrayList<Terminal>(wrapper.terminalList);
        this.namespaceList = new ArrayList<Namespace>(wrapper.namespaceList);
        this.sensorList = new ArrayList<Sensor>(wrapper.sensorList);
        this.resourceList = new ArrayList<Resource>(wrapper.resourceList);
        this.messageList = new ArrayList<Message>(wrapper.messageList);
        this.componentList = new ArrayList<Component>(wrapper.componentList);
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.structList = new ArrayList<Struct>(wrapper.structList);
        this.expressionList = new ArrayList<Expression>(wrapper.expressionList);
        this.entityDataList = new ArrayList<EntityData>(wrapper.entityDataList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Broker broker() {
        return this.broker;
    }

    public Datalake datalake() {
        return this.datalake;
    }

    public List<Datamart> datamartList() {
        return this.datamartList;
    }

    public List<Terminal> terminalList() {
        return this.terminalList;
    }

    public List<Namespace> namespaceList() {
        return this.namespaceList;
    }

    public List<Sensor> sensorList() {
        return this.sensorList;
    }

    public List<Resource> resourceList() {
        return this.resourceList;
    }

    public List<Message> messageList() {
        return this.messageList;
    }

    public List<Component> componentList() {
        return this.componentList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Struct> structList() {
        return this.structList;
    }

    public List<Expression> expressionList() {
        return this.expressionList;
    }

    public List<EntityData> entityDataList() {
        return this.entityDataList;
    }

    public Stream<Datamart> datamartList(Predicate<Datamart> filter) {
        return this.datamartList.stream().filter(filter);
    }

    public Datamart datamart(int index) {
        return this.datamartList.get(index);
    }

    public Stream<Terminal> terminalList(Predicate<Terminal> filter) {
        return this.terminalList.stream().filter(filter);
    }

    public Terminal terminal(int index) {
        return this.terminalList.get(index);
    }

    public Stream<Namespace> namespaceList(Predicate<Namespace> filter) {
        return this.namespaceList.stream().filter(filter);
    }

    public Namespace namespace(int index) {
        return this.namespaceList.get(index);
    }

    public Stream<Sensor> sensorList(Predicate<Sensor> filter) {
        return this.sensorList.stream().filter(filter);
    }

    public Sensor sensor(int index) {
        return this.sensorList.get(index);
    }

    public Stream<Resource> resourceList(Predicate<Resource> filter) {
        return this.resourceList.stream().filter(filter);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public Stream<Message> messageList(Predicate<Message> filter) {
        return this.messageList.stream().filter(filter);
    }

    public Message message(int index) {
        return this.messageList.get(index);
    }

    public Stream<Component> componentList(Predicate<Component> filter) {
        return this.componentList.stream().filter(filter);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Struct> structList(Predicate<Struct> filter) {
        return this.structList.stream().filter(filter);
    }

    public Struct struct(int index) {
        return this.structList.get(index);
    }

    public Stream<Expression> expressionList(Predicate<Expression> filter) {
        return this.expressionList.stream().filter(filter);
    }

    public Expression expression(int index) {
        return this.expressionList.get(index);
    }

    public Stream<EntityData> entityDataList(Predicate<EntityData> filter) {
        return this.entityDataList.stream().filter(filter);
    }

    public EntityData entityData(int index) {
        return this.entityDataList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Broker", new Indexer(node -> {
            this.broker = (Broker)node.as(Broker.class);
        }, node -> {
            this.broker = null;
        }, () -> {
            this.broker = null;
        }));
        map.put("Datalake", new Indexer(node -> {
            this.datalake = (Datalake)node.as(Datalake.class);
        }, node -> {
            this.datalake = null;
        }, () -> {
            this.datalake = null;
        }));
        map.put("Datamart", new Indexer(node -> this.datamartList.add((Datamart)node.as(Datamart.class)), node -> this.datamartList.remove(node.as(Datamart.class)), () -> this.datamartList.clear()));
        map.put("Terminal", new Indexer(node -> this.terminalList.add((Terminal)node.as(Terminal.class)), node -> this.terminalList.remove(node.as(Terminal.class)), () -> this.terminalList.clear()));
        map.put("Namespace", new Indexer(node -> this.namespaceList.add((Namespace)node.as(Namespace.class)), node -> this.namespaceList.remove(node.as(Namespace.class)), () -> this.namespaceList.clear()));
        map.put("Sensor", new Indexer(node -> this.sensorList.add((Sensor)node.as(Sensor.class)), node -> this.sensorList.remove(node.as(Sensor.class)), () -> this.sensorList.clear()));
        map.put("Resource", new Indexer(node -> this.resourceList.add((Resource)node.as(Resource.class)), node -> this.resourceList.remove(node.as(Resource.class)), () -> this.resourceList.clear()));
        map.put("Message", new Indexer(node -> this.messageList.add((Message)node.as(Message.class)), node -> this.messageList.remove(node.as(Message.class)), () -> this.messageList.clear()));
        map.put("Component", new Indexer(node -> this.componentList.add((Component)node.as(Component.class)), node -> this.componentList.remove(node.as(Component.class)), () -> this.componentList.clear()));
        map.put("Entity", new Indexer(node -> this.entityList.add((Entity)node.as(Entity.class)), node -> this.entityList.remove(node.as(Entity.class)), () -> this.entityList.clear()));
        map.put("Struct", new Indexer(node -> this.structList.add((Struct)node.as(Struct.class)), node -> this.structList.remove(node.as(Struct.class)), () -> this.structList.clear()));
        map.put("Expression", new Indexer(node -> this.expressionList.add((Expression)node.as(Expression.class)), node -> this.expressionList.remove(node.as(Expression.class)), () -> this.expressionList.clear()));
        map.put("EntityData", new Indexer(node -> this.entityDataList.add((EntityData)node.as(EntityData.class)), node -> this.entityDataList.remove(node.as(EntityData.class)), () -> this.entityDataList.clear()));
        return map;
    }

    public static Stash[] _language() {
        return new Stash[]{AbstractGraph.stash()};
    }

    private static Stash stash() {
        String content = AbstractGraph.stash0() + AbstractGraph.stash1() + AbstractGraph.stash2() + AbstractGraph.stash3() + AbstractGraph.stash4();
        return StashDeserializer.stashFrom((byte[])Base64.getDecoder().decode(content));
    }

    private static String stash0() {
        return "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";
    }

    private static String stash1() {
        return "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";
    }

    private static String stash2() {
        return "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";
    }

    private static String stash3() {
        return "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";
    }

    private static String stash4() {
        return "LkVudGl0eURhdGEkV29yZAEAAQABAABFbnRpdHlEYXRhJFdvcuQBAAEBAAFFbnRpdHlEYXRhJFR5cOUBAAJGYWNl9AEAAappby5pbnRpbm8uZGF0YWh1Yi5tb2RlbC5FbnRpdHlEYXRhJEVudGl0eQEAAQABAABFbnRpdHlEYXRhJEVudGl0+QEAAQEAAUVudGl0eURhdGEkVHlw5QEAAkZhY2X0AQABp2lvLmludGluby5kYXRhaHViLm1vZGVsLkVudGl0eURhdGEkTWFwAQABAAEAAEVudGl0eURhdGEkTWHwAQABAQABRW50aXR5RGF0YSRUeXDlAQACRmFjZfQBAIIBAwB0eXDlAQCCAwC2aW8uaW50aW5vLmRhdGFodWIubW9kZWwubmF0aXZlcy5lbnRpdHlkYXRhLm1hcC5UeXBlXzABAI4BAgACAEJyb2tl8gIARGF0YWxha+X+////DwBEYXRhbWFy9P7///8PAFRlcm1pbmHs/v///w8ATmFtZXNwYWPl/v///w8AU2Vuc2/y/v///w8AUmVzb3VyY+X+////DwBNZXNzYWfl/v///w8AQ29tcG9uZW70/v///w8ARW50aXT5/v///w8AU3RydWP0/v///w8ARXhwcmVzc2lv7v7///8PAEVudGl0eURhdOFQcm90Ze8BAAFNb2RlbC5zdGFz6AEAAYA=";
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Broker broker() {
            Broker newElement = (Broker)((Broker)AbstractGraph.this.graph.createRoot(Broker.class, this.stash, this.name)).a$(Broker.class);
            return newElement;
        }

        public Datalake datalake(Scale scale) {
            Datalake newElement = (Datalake)((Datalake)AbstractGraph.this.graph.createRoot(Datalake.class, this.stash, this.name)).a$(Datalake.class);
            newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
            return newElement;
        }

        public Datamart datamart() {
            Datamart newElement = (Datamart)((Datamart)AbstractGraph.this.graph.createRoot(Datamart.class, this.stash, this.name)).a$(Datamart.class);
            return newElement;
        }

        public Terminal terminal() {
            Terminal newElement = (Terminal)((Terminal)AbstractGraph.this.graph.createRoot(Terminal.class, this.stash, this.name)).a$(Terminal.class);
            return newElement;
        }

        public Namespace namespace() {
            Namespace newElement = (Namespace)((Namespace)AbstractGraph.this.graph.createRoot(Namespace.class, this.stash, this.name)).a$(Namespace.class);
            return newElement;
        }

        public Sensor sensor() {
            Sensor newElement = (Sensor)((Sensor)AbstractGraph.this.graph.createRoot(Sensor.class, this.stash, this.name)).a$(Sensor.class);
            return newElement;
        }

        public Resource resource() {
            Resource newElement = (Resource)((Resource)AbstractGraph.this.graph.createRoot(Resource.class, this.stash, this.name)).a$(Resource.class);
            return newElement;
        }

        public Message message() {
            Message newElement = (Message)((Message)AbstractGraph.this.graph.createRoot(Message.class, this.stash, this.name)).a$(Message.class);
            return newElement;
        }

        public Component component() {
            Component newElement = (Component)((Component)AbstractGraph.this.graph.createRoot(Component.class, this.stash, this.name)).a$(Component.class);
            return newElement;
        }

        public Entity entity() {
            Entity newElement = (Entity)((Entity)AbstractGraph.this.graph.createRoot(Entity.class, this.stash, this.name)).a$(Entity.class);
            return newElement;
        }

        public Struct struct() {
            Struct newElement = (Struct)((Struct)AbstractGraph.this.graph.createRoot(Struct.class, this.stash, this.name)).a$(Struct.class);
            return newElement;
        }
    }

    public class Clear {
        public void datamart(Predicate<Datamart> filter) {
            new ArrayList<Datamart>(AbstractGraph.this.datamartList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void terminal(Predicate<Terminal> filter) {
            new ArrayList<Terminal>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void namespace(Predicate<Namespace> filter) {
            new ArrayList<Namespace>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void sensor(Predicate<Sensor> filter) {
            new ArrayList<Sensor>(AbstractGraph.this.sensorList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void resource(Predicate<Resource> filter) {
            new ArrayList<Resource>(AbstractGraph.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void message(Predicate<Message> filter) {
            new ArrayList<Message>(AbstractGraph.this.messageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void entity(Predicate<Entity> filter) {
            new ArrayList<Entity>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void struct(Predicate<Struct> filter) {
            new ArrayList<Struct>(AbstractGraph.this.structList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    static interface Add {
        public void add(Node var1);
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface IndexClear {
        public void clear();
    }
}

