/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters.timelines;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.datamart.mounters.MounterUtils;
import io.intino.datahub.datamart.mounters.timelines.TimelineAssertionMounter;
import io.intino.datahub.datamart.mounters.timelines.TimelineCookedMounter;
import io.intino.datahub.datamart.mounters.timelines.TimelineRawMounter;
import io.intino.datahub.model.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import io.intino.sumus.chronos.timelines.stores.FileTimelineStore;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimelineMounter
extends MasterDatamartMounter {
    private final TimelineRawMounter rawMounter;
    private final TimelineAssertionMounter assertionMounter;
    private final TimelineCookedMounter cookedMounter;
    private final Map<String, Set<String>> timelineTypes;

    public TimelineMounter(MasterDatamart datamart) {
        super(datamart);
        this.timelineTypes = MounterUtils.timelineTypes(datamart);
        this.rawMounter = new TimelineRawMounter(this.box(), datamart, this.timelineTypes);
        this.assertionMounter = new TimelineAssertionMounter(this.box(), datamart);
        this.cookedMounter = new TimelineCookedMounter(this.box(), datamart, this.timelineTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mount(Event event) {
        MasterDatamart masterDatamart = this.datamart;
        synchronized (masterDatamart) {
            if (event instanceof MeasurementEvent) {
                MeasurementEvent e = (MeasurementEvent)event;
                this.rawMounter.mount(e);
            } else if (event instanceof MessageEvent) {
                MessageEvent e = (MessageEvent)event;
                this.mount(e.toMessage());
            }
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        if (this.isAssertion(message)) {
            this.assertionMounter.mount(new MessageEvent(message));
        } else if (this.isCooked(message)) {
            this.cookedMounter.mount(new MessageEvent(message));
        } else if (this.hasValues(message)) {
            this.rawMounter.mount(TimelineMounter.measurementEvent(message));
        }
    }

    public List<String> destinationsOf(Message message) {
        if (message == null || this.isAssertion(message)) {
            return Collections.emptyList();
        }
        if (this.isCooked(message)) {
            return this.cookedMounter.destinationsOf(new MessageEvent(message));
        }
        if (this.hasValues(message)) {
            return this.rawMounter.destinationsOf(TimelineMounter.measurementEvent(message));
        }
        return Collections.emptyList();
    }

    private boolean hasValues(Message message) {
        return message.contains("values");
    }

    private boolean isAssertion(Message message) {
        return this.datamart.definition().timelineList().stream().filter(t -> t.entity().from() != null).anyMatch(t -> t.entity().from().message().name$().equals(message.type()));
    }

    private boolean isCooked(Message message) {
        return this.datamart.definition().timelineList().stream().filter(Timeline::isCooked).anyMatch(t -> this.timelineTypes.get(t.name$()).contains(message.type()));
    }

    private static MeasurementEvent measurementEvent(Message message) {
        return new MeasurementEvent(message.type(), message.get("ss").asString(), message.get("ts").asInstant(), TimelineMounter.measurements(message), TimelineMounter.values(message));
    }

    private static MeasurementEvent.Magnitude[] measurements(Message message) {
        List measurements = message.get("magnitudes").asList(String.class);
        return (MeasurementEvent.Magnitude[])measurements.stream().map(TimelineMounter::magnitude).toArray(MeasurementEvent.Magnitude[]::new);
    }

    private static MeasurementEvent.Magnitude magnitude(String m) {
        String[] fields = m.split(";");
        return new MeasurementEvent.Magnitude(fields[0], TimelineMounter.attributes(fields));
    }

    private static MeasurementEvent.Magnitude.Attribute[] attributes(String[] m) {
        return (MeasurementEvent.Magnitude.Attribute[])Arrays.stream(m).skip(1L).map(a -> new MeasurementEvent.Magnitude.Attribute(a.split("="))).toArray(MeasurementEvent.Magnitude.Attribute[]::new);
    }

    private static double[] values(Message message) {
        return Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray();
    }

    public static class OfSingleTimeline
    implements AutoCloseable {
        private final TimelineRawMounter.OfSingleTimeline rawMounter;
        private final TimelineAssertionMounter.OfSingleTimeline assertionMounter;
        private final String ss;
        private final TimelineFileFactory timelineFactory;
        private TimelineWriter writer;
        private File sessionFile;

        public OfSingleTimeline(MasterDatamart datamart, Timeline timeline, String tank, String ss) {
            this.ss = ss;
            this.timelineFactory = ts -> MounterUtils.rawTimelineBuilder().datamart(datamart).datamartDir(datamart.box().datamartTimelinesDirectory(datamart.name())).type(tank).entity(ss).start(ts).withExtension(".session").createIfNotExists();
            this.rawMounter = new TimelineRawMounter.OfSingleTimeline(datamart, this::getTimelineWriter);
            this.assertionMounter = new TimelineAssertionMounter.OfSingleTimeline(datamart, timeline, this::getTimelineWriter);
        }

        public void mount(Event event) {
            this.createTimelineFileIfNotExists(event.ts());
            if (event instanceof MeasurementEvent) {
                MeasurementEvent e = (MeasurementEvent)event;
                this.rawMounter.mount(e);
            } else if (event instanceof MessageEvent) {
                MessageEvent e = (MessageEvent)event;
                if (this.ss.equals(MounterUtils.sourceSensor(event))) {
                    this.assertionMounter.mount(new MessageEvent(e.toMessage()));
                }
            }
        }

        private void createTimelineFileIfNotExists(Instant ts) {
            if (this.writer != null) {
                return;
            }
            try {
                TimelineStore store = this.timelineFactory.create(ts);
                this.writer = store.writer();
                this.sessionFile = ((FileTimelineStore)store).file();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.writer != null) {
                this.writer.close();
                File timelineFile = new File(this.sessionFile.getAbsolutePath().replace(".session", ""));
                Files.move(this.sessionFile.toPath(), timelineFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
        }

        private TimelineWriter getTimelineWriter() {
            return this.writer;
        }

        private static interface TimelineFileFactory {
            public TimelineStore create(Instant var1) throws Exception;
        }
    }
}

