/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters.timelines;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.TimeShiftCache;
import io.intino.datahub.datamart.mounters.MounterUtils;
import io.intino.datahub.datamart.mounters.timelines.IndicatorMounter;
import io.intino.datahub.model.Timeline;
import io.intino.magritte.framework.Layer;
import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.MeasurementsVector;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimeSeries;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import io.intino.sumus.chronos.timelines.stores.FileTimelineStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TimelineCookedMounter {
    private final MasterDatamart datamart;
    private final Map<String, Set<String>> timelineTypes;
    private final File tlDirectory;
    private final IndicatorMounter indicatorMounter;
    private final File temp;

    public TimelineCookedMounter(DataHubBox box, MasterDatamart datamart, Map<String, Set<String>> timelineTypes) {
        this.datamart = datamart;
        this.timelineTypes = timelineTypes;
        this.tlDirectory = box.datamartTimelinesDirectory(datamart.name());
        this.indicatorMounter = new IndicatorMounter(datamart);
        this.temp = MounterUtils.tempDir("reel_mounter");
    }

    public void mount(MessageEvent event) {
        this.datamart.definition().timelineList().stream().filter(Timeline::isCooked).map(Timeline::asCooked).filter(t -> this.timelineTypes.getOrDefault(t.name$(), Set.of()).contains(event.type())).forEach(t -> this.mount(event, (Timeline.Cooked)((Object)t)));
    }

    public List<String> destinationsOf(MessageEvent event) {
        return this.datamart.definition().timelineList().stream().filter(Timeline::isCooked).map(Timeline::asCooked).filter(t -> this.timelineTypes.getOrDefault(t.name$(), Set.of()).contains(event.type())).map(t -> t.name$() + "\u0000" + TimelineCookedMounter.entityOf(event, t)).toList();
    }

    protected void mount(MessageEvent event, Timeline.Cooked timelineDefinition) {
        String entityId = TimelineCookedMounter.entityOf(event, timelineDefinition);
        if (entityId == null) {
            return;
        }
        TimelineStore timelineStore = this.updateTimeline(event, timelineDefinition, entityId);
        if (timelineStore != null && timelineDefinition.asTimeline().isIndicator()) {
            this.indicatorMounter.mount(timelineDefinition.name$(), timelineStore);
        }
    }

    protected TimelineStore updateTimeline(MessageEvent event, Timeline.Cooked definition, String entityId) {
        try {
            TimelineStore store = this.getOrCreateTimelineStore(event, definition, entityId);
            if (store == null) {
                return null;
            }
            this.updateTimeline(store, definition, event);
            return store;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private TimelineStore getOrCreateTimelineStore(MessageEvent event, Timeline.Cooked timelineDef, String entityId) throws IOException {
        TimelineStore timelineFile = this.datamart.timelineStore().get(timelineDef.name$(), entityId);
        return timelineFile == null ? this.createTimelineStore(timelineDef, event.ts(), entityId) : timelineFile;
    }

    private static String entityOf(MessageEvent event, Timeline.Cooked definition) {
        Timeline.Cooked.TimeSeries timeSeries = definition.timeSeries(ts -> ts.tank().message().name$().equals(event.type()));
        if (timeSeries != null) {
            return event.toMessage().get(timeSeries.entityId().name$()).asString();
        }
        for (Timeline.Cooked.TimeSeries series : definition.timeSeriesList()) {
            if (series.isCount()) {
                Timeline.Cooked.TimeSeries.Count.Operation operation = series.asCount().operation(o -> o.tank().message().name$().equals(event.type()));
                if (operation == null) continue;
                return event.toMessage().get(operation.entityId().name$()).asString();
            }
            if (!series.asTimeShift().withTank().message().name$().equals(event.type())) continue;
            return event.toMessage().get(series.asTimeShift().withEntityId().name$()).asString();
        }
        return null;
    }

    private void updateTimeline(TimelineStore tlStore, Timeline.Cooked definition, MessageEvent event) {
        block10: {
            File timelineFile = ((FileTimelineStore)tlStore).file();
            File sessionFile = null;
            try {
                io.intino.sumus.chronos.Timeline timeline = tlStore.timeline();
                sessionFile = MounterUtils.copyOf(this.temp, timelineFile, ".session");
                try (TimelineWriter writer = TimelineStore.of((File)sessionFile).writer();){
                    MeasurementsVector vector = TimelineCookedMounter.createVector(tlStore.sensorModel());
                    writer.set(event.ts());
                    for (Timeline.Cooked.TimeSeries ts : this.timeSeries(definition, event.type())) {
                        this.fillMeasurements(tlStore, vector, event, ts);
                    }
                    TimelineCookedMounter.fillNaNValues(tlStore.sensorModel(), vector, timeline);
                    writer.set(vector);
                }
                Files.move(sessionFile.toPath(), timelineFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                if (sessionFile == null) break block10;
                sessionFile.delete();
            }
        }
    }

    private static MeasurementsVector createVector(TimelineStore.SensorModel sensorModel) {
        MeasurementsVector measurements = new MeasurementsVector(sensorModel);
        sensorModel.forEach(m -> measurements.set(m.label, Double.NaN));
        return measurements;
    }

    private static void fillNaNValues(TimelineStore.SensorModel sensorModel, MeasurementsVector measurements, io.intino.sumus.chronos.Timeline timeline) {
        sensorModel.forEach(m -> {
            TimeSeries.Point last;
            if (Double.isNaN(measurements.toArray()[measurements.sensorModel().indexOf(m.label)]) && (last = timeline.get(m.label).last()) != null) {
                measurements.set(m.label, last.value());
            }
        });
    }

    private void fillMeasurements(TimelineStore tlFile, MeasurementsVector vector, MessageEvent event, Timeline.Cooked.TimeSeries ts) throws IOException {
        if (ts.isCount()) {
            this.processCount(vector, ts.asCount(), TimelineCookedMounter.lastValue(tlFile, ts), this.operationOf(ts.asCount().operationList(), event.type()));
        } else if (ts.isTimeShift()) {
            this.processTimeShift(vector, ts.asTimeShift(), event);
        }
    }

    private Timeline.Cooked.TimeSeries.Count.Operation operationOf(List<Timeline.Cooked.TimeSeries.Count.Operation> operations, String type) {
        return operations.stream().filter(o -> o.tank().message().name$().equals(type)).findFirst().orElse(null);
    }

    private void processCount(MeasurementsVector measurements, Timeline.Cooked.TimeSeries.Count ts, TimeSeries.Point last, Timeline.Cooked.TimeSeries.Count.Operation operation) {
        double value;
        double d = value = last == null ? 0.0 : last.value();
        if (operation instanceof Timeline.Cooked.TimeSeries.Count.Difference) {
            measurements.set(ts.name$(), Math.max(0.0, value - 1.0));
        } else {
            measurements.set(ts.name$(), value + 1.0);
        }
    }

    private void processTimeShift(MeasurementsVector measurements, Timeline.Cooked.TimeSeries.TimeShift timeSeries, MessageEvent event) {
        if (event.type().equals(timeSeries.tank().message().name$())) {
            this.save(timeSeries, event);
        } else {
            Instant last = this.load(timeSeries, event);
            if (last != null) {
                measurements.set(timeSeries.name$(), (double)last.until(event.ts(), ChronoUnit.SECONDS));
            }
        }
    }

    private void save(Timeline.Cooked.TimeSeries.TimeShift timeSeries, MessageEvent event) {
        TimeShiftCache cache = this.cache(timeSeries);
        cache.put(event.toMessage().get(timeSeries.entityId().name$()).asString(), event.ts());
    }

    private Instant load(Timeline.Cooked.TimeSeries.TimeShift timeSeries, MessageEvent event) {
        return this.cache(timeSeries).get(event.toMessage().get(timeSeries.entityId().name$()).asString());
    }

    private TimeShiftCache cache(Timeline.Cooked.TimeSeries.TimeShift timeseries) {
        return this.datamart.cacheOf(((Timeline)timeseries.core$().ownerAs(Timeline.class)).name$());
    }

    private static TimeSeries.Point lastValue(TimelineStore tlFile, Timeline.Cooked.TimeSeries ts) throws IOException {
        TimeSeries.Point point;
        for (point = tlFile.timeline().get(ts.name$()).last(); point != null && Double.isNaN(point.value()); point = point.prev()) {
        }
        return point;
    }

    private List<Timeline.Cooked.TimeSeries> timeSeries(Timeline.Cooked definition, String type) {
        return definition.timeSeriesList(ts -> this.timelineTypes.get(definition.name$()).contains(type));
    }

    private TimelineStore createTimelineStore(Timeline.Cooked timeline, Instant start, String entity) throws IOException {
        File file = new File(this.tlDirectory, MasterDatamart.normalizePath(timeline.name$() + File.separator + entity + ".timeline"));
        file.getParentFile().mkdirs();
        return TimelineStore.createIfNotExists((String)entity, (File)file).withTimeModel(start, new Period(1, ChronoUnit.SECONDS)).withSensorModel(TimelineCookedMounter.sensorModel(timeline)).build();
    }

    static Magnitude[] sensorModel(Timeline.Cooked timeline) {
        return (Magnitude[])timeline.timeSeriesList().stream().map(ts -> new Magnitude(ts.name$(), new Magnitude.Model(ts.attributeList().stream().collect(Collectors.toMap(Layer::name$, Timeline.Cooked.TimeSeries.Attribute::value))))).toArray(Magnitude[]::new);
    }

    public static class OneShot
    extends TimelineCookedMounter {
        public OneShot(DataHubBox box, MasterDatamart datamart, Map<String, Set<String>> timelineTypes) {
            super(box, datamart, timelineTypes);
        }

        @Override
        protected void mount(MessageEvent event, Timeline.Cooked timelineDefinition) {
            String entityId = TimelineCookedMounter.entityOf(event, timelineDefinition);
            if (entityId != null) {
                this.updateTimeline(event, timelineDefinition, entityId);
            }
        }
    }
}

