/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters.timelines;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MounterUtils;
import io.intino.datahub.model.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;

public class TimelineAssertionMounter {
    private final DataHubBox box;
    private final MasterDatamart datamart;
    private final File temp;

    public TimelineAssertionMounter(DataHubBox box, MasterDatamart datamart) {
        this.box = box;
        this.datamart = datamart;
        this.temp = MounterUtils.tempDir("timeline_assertion_mounter");
    }

    void mount(MessageEvent assertion) {
        this.datamart.definition().timelineList().stream().filter(t -> t.entity().from() != null && t.entity().from().message().name$().equals(assertion.type())).findFirst().ifPresent(t -> this.updateSensorModel(assertion, (Timeline)((Object)t)));
    }

    void updateSensorModel(MessageEvent assertion, Timeline t) {
        block10: {
            File timelineDirectory = new File(this.box.datamartTimelinesDirectory(this.datamart.name()), t.asRaw().tank().sensor().name$());
            File timelineFile = new File(timelineDirectory, assertion.toMessage().get("id").asString() + ".timeline");
            if (!timelineFile.exists()) {
                return;
            }
            File session = null;
            try {
                session = MounterUtils.copyOf(this.temp, timelineFile, ".session");
                try (TimelineWriter writer = TimelineStore.of((File)session).writer();){
                    writer.sensorModel(MounterUtils.sensorModel(TimelineStore.of((File)timelineFile).sensorModel(), assertion.toMessage(), t));
                }
                Files.move(session.toPath(), timelineFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                if (session == null) break block10;
                session.delete();
            }
        }
    }

    public static class OfSingleTimeline
    extends TimelineAssertionMounter {
        private final Timeline timeline;
        private final Supplier<TimelineWriter> writer;

        public OfSingleTimeline(MasterDatamart datamart, Timeline timeline, Supplier<TimelineWriter> writer) {
            super(datamart.box(), datamart);
            this.timeline = timeline;
            this.writer = writer;
        }

        @Override
        void mount(MessageEvent assertion) {
            try {
                this.writer.get().sensorModel(MounterUtils.sensorModel(this.writer.get().sensorModel(), assertion.toMessage(), this.timeline));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }
}

