/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Timeline;
import io.intino.magritte.framework.Layer;
import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimelineStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MounterUtils {
    public static Map<String, Set<String>> timelineTypes(MasterDatamart datamart) {
        return datamart.definition().timelineList().stream().collect(Collectors.toMap(Layer::name$, t -> MounterUtils.types(t).collect(Collectors.toSet())));
    }

    public static String sourceSensor(Event event) {
        Map<String, String> parameters = MounterUtils.parameters(event.ss());
        String sensor = parameters.get("sensor");
        String cleanSS = MounterUtils.withOutParameters(event.ss());
        return sensor == null ? cleanSS : sensor;
    }

    public static Magnitude[] sensorModel(TimelineStore.SensorModel current, Message assertion, Timeline timeline) {
        Sensor sensor = timeline.asRaw().tank().sensor();
        return (Magnitude[])sensor.magnitudeList().stream().map(m -> new Magnitude(m.id(), new Magnitude.Model(MounterUtils.merge(m, current, assertion, m.attributeList(), timeline.asRaw().attributeList())))).toArray(Magnitude[]::new);
    }

    public static Stream<String> types(Timeline t) {
        return MounterUtils.asTypes(MounterUtils.tanksOf(t));
    }

    public static Stream<String> tanksOf(Timeline t) {
        HashSet<String> tanks = new HashSet<String>();
        String entityTank = MounterUtils.tankName(t.entity());
        if (entityTank != null) {
            tanks.add(entityTank);
        }
        if (t.isRaw()) {
            tanks.add(MounterUtils.tankName(t.asRaw().tank().sensor()));
        } else {
            tanks.addAll(MounterUtils.getCookedTanks(t));
        }
        return tanks.stream();
    }

    public static Set<String> getCookedTanks(Timeline t) {
        HashSet<String> tanks = new HashSet<String>();
        t.asCooked().timeSeriesList().stream().map(ts -> MounterUtils.tankName(ts.tank())).forEach(tanks::add);
        t.asCooked().timeSeriesList().stream().filter(Timeline.Cooked.TimeSeries::isCount).flatMap(ts -> MounterUtils.tanksOf(ts.asCount())).forEach(tanks::add);
        return tanks;
    }

    public static TimelineStoreBuilder rawTimelineBuilder() {
        return new TimelineStoreBuilder();
    }

    public static File timelineFileOf(File datamartDir, String name, String entity) {
        return new File(datamartDir, name + File.separator + entity + ".timeline");
    }

    public static File copyOf(File temp, File file, String newExtension) throws IOException {
        File copy = new File(temp, file.getName() + newExtension);
        if (file.exists()) {
            copy.delete();
            Files.copy(file.toPath(), copy.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return copy;
    }

    public static File tempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static String tankName(Entity e) {
        return e.from() == null ? null : e.from().message().core$().fullName().replace("$", ".");
    }

    private static String withOutParameters(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }

    private static Map<String, String> parameters(String ss) {
        int i = ss.indexOf("?");
        if (i < 0 || i == ss.length() - 1) {
            return Map.of();
        }
        String[] parameters = ss.substring(i + 1).split(";");
        return Arrays.stream(parameters).map(p -> p.split("=")).collect(Collectors.toMap(p -> p[0], p -> p[1]));
    }

    private static Stream<String> tanksOf(Timeline.Cooked.TimeSeries.Count ts) {
        return ts.operationList().stream().map(d -> MounterUtils.tankName(d.tank()));
    }

    private static Map<String, String> merge(Sensor.Magnitude m, TimelineStore.SensorModel current, Message message, List<Sensor.Magnitude.Attribute> magnitudeAttr, List<Timeline.Raw.Attribute> timelineAttr) {
        Magnitude magnitude;
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Sensor.Magnitude.Attribute attribute : magnitudeAttr) {
            attrs.put(attribute.name$(), attribute.value());
        }
        if (current != null && (magnitude = current.get(m.id())) != null) {
            Magnitude.Model model = magnitude.model;
            model.attributes().forEach(a -> attrs.put((String)a, model.attribute(a)));
        }
        if (message == null) {
            return attrs;
        }
        MounterUtils.addMessageAttributes(m, message, timelineAttr, attrs);
        return attrs;
    }

    private static void addMessageAttributes(Sensor.Magnitude m, Message message, List<Timeline.Raw.Attribute> timelineAttr, Map<String, String> attrs) {
        timelineAttr.stream().filter(a -> ((Object)((Object)a.magnitude())).equals((Object)m)).forEach(a -> {
            String value = MounterUtils.valueOf(message, a.from());
            if (value != null) {
                attrs.put(a.name$(), value);
            }
        });
    }

    private static Stream<String> asTypes(Stream<String> tanks) {
        return tanks.map(t -> t.contains(".") ? t.substring(t.lastIndexOf(".") + 1) : t);
    }

    private static String tankName(Sensor sensor) {
        return sensor.core$().fullName().replace("$", ".");
    }

    private static String tankName(Datalake.Tank.Message tank) {
        return tank.message().core$().fullName().replace("$", ".");
    }

    private static String valueOf(Message message, Entity.Attribute source) {
        return message.get(source.name$()).asString();
    }

    public static class TimelineStoreBuilder {
        private File datamartDir;
        private MasterDatamart datamart;
        private Instant start;
        private String type;
        private String entity;
        private String extension;

        public TimelineStore createIfNotExists() throws IOException {
            File file = MounterUtils.timelineFileOf(this.datamartDir, this.type, MasterDatamart.normalizePath(this.entity));
            if (this.extension != null) {
                file = new File(file.getAbsolutePath() + this.extension);
            }
            file.getParentFile().mkdirs();
            if (file.exists()) {
                return TimelineStore.of((File)file);
            }
            return this.createTimeline(file, this.definition());
        }

        private TimelineStore createTimeline(File file, Timeline definition) throws IOException {
            return TimelineStore.createIfNotExists((String)this.entity, (File)file).withSensorModel(MounterUtils.sensorModel(null, this.datamart.entityStore().get(this.entity), definition)).withTimeModel(this.start, new Period(definition.asRaw().tank().period(), definition.asRaw().tank().periodScale().chronoUnit())).build();
        }

        private Timeline definition() throws IOException {
            return this.datamart.definition().timelineList().stream().filter(Timeline::isRaw).filter(t -> t.asRaw().tank().sensor().name$().equals(this.type)).findFirst().orElseThrow(() -> new IOException("Tank not found: " + this.type));
        }

        public TimelineStoreBuilder withExtension(String extension) {
            this.extension = extension;
            return this;
        }

        public TimelineStoreBuilder datamartDir(File datamartDir) {
            this.datamartDir = datamartDir;
            return this;
        }

        public TimelineStoreBuilder datamart(MasterDatamart datamart) {
            this.datamart = datamart;
            return this;
        }

        public TimelineStoreBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        public TimelineStoreBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TimelineStoreBuilder entity(String entity) {
            this.entity = entity;
            return this;
        }
    }
}

