/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.service.jms;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.model.Attribute;
import io.intino.datahub.model.Component;
import io.intino.datahub.model.Datalake;
import jakarta.jms.Message;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MetamodelRequest {
    private final DataHubBox box;

    public MetamodelRequest(DataHubBox box) {
        this.box = box;
    }

    public Stream<Message> accept(Message request) {
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setBooleanProperty("success", true);
            message.setText(this.calculateResponse());
            return Stream.of(message);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return Stream.of(new Message[0]);
        }
    }

    public String calculateResponse() {
        List<io.intino.datahub.model.Message> messages = this.box.graph().datalake().tankList(Datalake.Tank::isMessage).stream().map((? super T t) -> t.asMessage().message()).toList();
        JsonArray elements = new JsonArray();
        for (io.intino.datahub.model.Message message : messages) {
            JsonArray components;
            JsonObject obj = new JsonObject();
            if (message.isAssertion()) {
                obj.add("assertion", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
            obj.add("name", (JsonElement)new JsonPrimitive(message.name$()));
            obj.add("attributes", (JsonElement)this.attributes(message));
            if (message.isExtensionOf()) {
                obj.add("hierarchy", this.hierarchy(message));
            }
            if (!(components = this.components(message)).isEmpty()) {
                obj.add("components", (JsonElement)components);
            }
            elements.add((JsonElement)obj);
        }
        return Json.toJson((Object)elements);
    }

    private JsonElement hierarchy(io.intino.datahub.model.Message message) {
        io.intino.datahub.model.Message current = message;
        JsonArray hierarchy = new JsonArray();
        while (current.isExtensionOf()) {
            io.intino.datahub.model.Message parent = current.asExtensionOf().parent();
            hierarchy.add((JsonElement)new JsonPrimitive(parent.name$()));
            current = parent;
        }
        return hierarchy;
    }

    private JsonArray attributes(io.intino.datahub.model.Message message) {
        JsonArray attributes = new JsonArray();
        attributes.addAll(this.attributes(message.attributeList()));
        if (message.isExtensionOf()) {
            attributes.addAll(this.attributes(message.asExtensionOf().parent()));
        }
        return attributes;
    }

    private JsonArray attributes(List<Attribute> attributeList) {
        List<JsonObject> attributes = attributeList.stream().map(this::map).toList();
        JsonArray jsonElements = new JsonArray();
        attributes.forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        return jsonElements;
    }

    private JsonArray components(io.intino.datahub.model.Message message) {
        JsonArray components = new JsonArray();
        components.addAll(this.components(message.componentList()));
        if (message.isExtensionOf()) {
            components.addAll(this.components(message.asExtensionOf().parent()));
        }
        return components;
    }

    private JsonObject map(Attribute a) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", (JsonElement)new JsonPrimitive(a.name$()));
        jsonObject.add("type", (JsonElement)new JsonPrimitive(a.asType().type()));
        return jsonObject;
    }

    private JsonArray components(Component owner) {
        JsonArray components = new JsonArray();
        components.addAll(this.components(owner.componentList()));
        if (owner.isExtensionOf()) {
            components.addAll(this.components(owner.asExtensionOf().parent()));
        }
        components.addAll(this.components(owner.hasList().stream().map(Component.Has::element).collect(Collectors.toList())));
        return components;
    }

    private JsonArray components(List<Component> components) {
        JsonArray jsonElements = new JsonArray();
        components.stream().map(this::map).forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        return jsonElements;
    }

    private JsonObject map(Component component) {
        JsonObject obj = new JsonObject();
        obj.add("name", (JsonElement)new JsonPrimitive(component.name$()));
        obj.add("multiple", (JsonElement)new JsonPrimitive(Boolean.valueOf(component.multiple())));
        obj.add("attributes", (JsonElement)this.attributes(component));
        obj.add("components", (JsonElement)this.components(component));
        return obj;
    }

    private JsonArray attributes(Component component) {
        JsonArray attributes = new JsonArray();
        attributes.addAll(this.attributes(component.attributeList()));
        if (component.isExtensionOf()) {
            attributes.addAll(this.attributes(component.asExtensionOf().parent()));
        }
        return attributes;
    }
}

